/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.com.ziclix.python.sql.util;

import java.util.HashMap;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyObject;

public class PyArgParser {
    protected Map<String, PyObject> keywords = new HashMap<String, PyObject>();
    protected PyObject[] arguments = null;

    public PyArgParser(PyObject[] args, String[] kws) {
        this.parse(args, kws);
    }

    protected void parse(PyObject[] args, String[] kws) {
        int largs = args.length;
        if (kws != null) {
            for (int i = kws.length - 1; i >= 0; --i) {
                this.keywords.put(kws[i], args[--largs]);
            }
        }
        this.arguments = new PyObject[largs];
        System.arraycopy(args, 0, this.arguments, 0, largs);
    }

    public int numKw() {
        return this.keywords.keySet().size();
    }

    public boolean hasKw(String kw) {
        return this.keywords.containsKey(kw);
    }

    public PyObject kw(String kw) {
        if (!this.hasKw(kw)) {
            throw Py.KeyError(kw);
        }
        return this.keywords.get(kw);
    }

    public PyObject kw(String kw, PyObject def) {
        if (!this.hasKw(kw)) {
            return def;
        }
        return this.keywords.get(kw);
    }

    public String[] kws() {
        return this.keywords.keySet().toArray(new String[0]);
    }

    public int numArg() {
        return this.arguments.length;
    }

    public PyObject arg(int index) {
        if (index >= 0 && index <= this.arguments.length - 1) {
            return this.arguments[index];
        }
        throw Py.IndexError("index out of range");
    }

    public PyObject arg(int index, PyObject def) {
        if (index >= 0 && index <= this.arguments.length - 1) {
            return this.arguments[index];
        }
        return def;
    }
}

