/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.PlotDialog;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class PlotCanvas
extends ImageCanvas {
    Plot plot;
    int xScrolled;
    int yScrolled;
    int oldWidth;
    int oldHeight;
    int rangeArrowIndexWhenPressed = -1;

    public PlotCanvas(ImagePlus imp) {
        super(imp);
        this.oldWidth = imp.getWidth();
        this.oldHeight = imp.getHeight();
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public boolean isFrozen() {
        return this.plot != null && this.plot.isFrozen();
    }

    public void zoom(String arg) {
        int cursorX = -1;
        int cursorY = -1;
        if (this.cursorOverImage()) {
            Point cursorLoc = this.getCursorLoc();
            cursorX = this.screenX(cursorLoc.x);
            cursorY = this.screenY(cursorLoc.y);
        }
        Rectangle roiRect = null;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isArea()) {
            roiRect = roi.getBounds();
        }
        if (arg.equals("in")) {
            if (roiRect != null) {
                this.plot.zoomToRect(roiRect);
                this.imp.deleteRoi();
            } else {
                this.zoomIn(cursorX, cursorY);
            }
        } else if (arg.equals("out")) {
            this.zoomOut(cursorX, cursorY);
        } else if (arg.equals("orig")) {
            this.unzoom();
        } else if (arg.equals("100%")) {
            this.zoom100Percent();
        } else if (arg.equals("to") && roiRect != null) {
            this.plot.zoomToRect(roiRect);
            this.imp.deleteRoi();
        } else if (arg.equals("set")) {
            new PlotDialog(this.plot, 0).showDialog(null);
        } else if (arg.equals("max")) {
            ImageWindow win = this.imp.getWindow();
            win.setBounds(win.getMaximumBounds());
            win.maximize();
        } else if (arg.equals("scale")) {
            this.plot.setLimitsToFit(true);
        }
    }

    @Override
    public void zoomIn(int sx, int sy) {
        this.zoom(sx, sy, Math.sqrt(2.0));
    }

    @Override
    public void zoomOut(int sx, int sy) {
        this.zoom(sx, sy, Math.sqrt(0.5));
    }

    void zoom(int sx, int sy, double zoomFactor) {
        boolean mouseMoved;
        if (this.plot == null || this.plot.isFrozen()) {
            if (zoomFactor > 1.0) {
                super.zoomIn(sx, sy);
            } else {
                super.zoomOut(sx, sy);
            }
            return;
        }
        boolean bl = mouseMoved = this.sqr(sx - this.lastZoomSX) + this.sqr(sy - this.lastZoomSY) > 100;
        if (mouseMoved) {
            this.plot.zoom(sx, sy, zoomFactor);
        } else {
            this.plot.zoom(-20202020, 20202020, zoomFactor);
        }
        this.lastZoomSX = sx;
        this.lastZoomSY = sy;
    }

    @Override
    public void unzoom() {
        if (this.plot == null || this.plot.isFrozen()) {
            super.unzoom();
            return;
        }
        this.resetMagnification();
        this.plot.setLimitsToDefaults(true);
    }

    @Override
    public void zoom100Percent() {
        if (this.plot == null || this.plot.isFrozen()) {
            super.zoom100Percent();
            return;
        }
        this.resetMagnification();
        this.plot.setFrameSize(PlotWindow.plotWidth, PlotWindow.plotHeight);
    }

    @Override
    public void fitToWindow() {
        if (this.plot == null || this.plot.isFrozen()) {
            super.fitToWindow();
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return;
        }
        Rectangle bounds = win.getBounds();
        Dimension extraSize = win.getExtraSize();
        int width = bounds.width - extraSize.width;
        int height = bounds.height - extraSize.height;
        this.resizeCanvas(width, height);
        this.getParent().doLayout();
    }

    @Override
    void resizeCanvas(int width, int height) {
        if (this.plot == null || this.plot.isFrozen()) {
            super.resizeCanvas(width, height);
            return;
        }
        this.resetMagnification();
        if (width == this.oldWidth && height == this.oldHeight) {
            return;
        }
        if (this.plot == null) {
            return;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null || !(win instanceof PlotWindow)) {
            return;
        }
        if (!((PlotWindow)win).layoutDone) {
            return;
        }
        ((PlotWindow)win).updateMinimumSize();
        Dimension minSize = this.plot.getMinimumSize();
        int plotWidth = width < minSize.width ? minSize.width : width;
        int plotHeight = height < minSize.height ? minSize.height : height;
        this.plot.setSize(plotWidth, plotHeight);
        this.setSize(width, height);
        this.oldWidth = width;
        this.oldHeight = height;
    }

    @Override
    public void setMagnification(double magnification) {
        if (this.plot == null || this.plot.isFrozen()) {
            super.setMagnification(magnification);
        } else {
            this.resetMagnification();
        }
    }

    @Override
    public void setSourceRect(Rectangle r) {
        if (this.plot.isFrozen()) {
            super.setSourceRect(r);
        } else {
            this.resetMagnification();
        }
    }

    void resetMagnification() {
        this.magnification = 1.0;
        this.srcRect.x = 0;
        this.srcRect.y = 0;
    }

    @Override
    protected void setupScroll(int ox, int oy) {
        if (this.plot.isFrozen()) {
            super.setupScroll(ox, oy);
            return;
        }
        this.xMouseStart = ox;
        this.yMouseStart = oy;
        this.xScrolled = 0;
        this.yScrolled = 0;
    }

    @Override
    protected void scroll(int sx, int sy) {
        if (this.plot.isFrozen()) {
            super.scroll(sx, sy);
            return;
        }
        if (sx == 0 && sy == 0) {
            return;
        }
        if (this.xScrolled == 0 && this.yScrolled == 0) {
            this.plot.saveMinMax();
        }
        int dx = sx - this.xMouseStart;
        int dy = sy - this.yMouseStart;
        this.plot.scroll(dx - this.xScrolled, dy - this.yScrolled);
        this.xScrolled = dx;
        this.yScrolled = dy;
        Thread.yield();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ImageWindow win = this.imp.getWindow();
        if (win instanceof PlotWindow) {
            ((PlotWindow)win).mouseExited(e);
        }
        super.mouseExited(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.rangeArrowIndexWhenPressed = this.getRangeArrowIndex(e);
        if (this.rangeArrowIndexWhenPressed < 0) {
            super.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.rangeArrowIndexWhenPressed >= 0 && this.rangeArrowIndexWhenPressed == this.getRangeArrowIndex(e)) {
            this.plot.zoomOnRangeArrow(this.rangeArrowIndexWhenPressed);
        } else {
            super.mouseReleased(e);
        }
    }

    int getRangeArrowIndex(MouseEvent e) {
        ImageWindow win = this.imp.getWindow();
        int rangeArrowIndex = -1;
        if (win instanceof PlotWindow) {
            int x = e.getX();
            int y = e.getY();
            rangeArrowIndex = ((PlotWindow)win).getRangeArrowIndex(x, y);
        }
        return rangeArrowIndex;
    }
}

