/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GenericDialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

public class NonBlockingGenericDialog
extends GenericDialog {
    public NonBlockingGenericDialog(String title) {
        super(title, null);
        this.setModal(false);
    }

    @Override
    public synchronized void showDialog() {
        super.showDialog();
        if (this.isMacro()) {
            return;
        }
        if (!IJ.macroRunning()) {
            final NonBlockingGenericDialog thisDialog = this;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManager.addWindow(thisDialog);
                }
            });
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!this.isVisible()) {
            this.notify();
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        WindowManager.removeWindow(this);
    }
}

