/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.View;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.CompositeFactory;

public class CompositeView<T, C extends Composite<T>>
implements RandomAccessible<C>,
View {
    protected final CompositeFactory<T, C> compositeFactory;
    protected final RandomAccessible<T> source;
    protected final int n;

    public CompositeView(RandomAccessible<T> source, CompositeFactory<T, C> compositeFactory) {
        this.source = source;
        this.compositeFactory = compositeFactory;
        this.n = source.numDimensions() - 1;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public CompositeRandomAccess randomAccess() {
        return new CompositeRandomAccess();
    }

    public CompositeRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class CompositeRandomAccess
    implements RandomAccess<C> {
        protected final RandomAccess<T> sourceAccess;
        protected final C composite;

        public CompositeRandomAccess() {
            this.sourceAccess = CompositeView.this.source.randomAccess();
            this.composite = CompositeView.this.compositeFactory.create(this.sourceAccess);
        }

        protected CompositeRandomAccess(CompositeRandomAccess other) {
            this.sourceAccess = other.sourceAccess.copyRandomAccess();
            this.composite = CompositeView.this.compositeFactory.create(this.sourceAccess);
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                position[d] = this.sourceAccess.getIntPosition(d);
            }
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                position[d] = this.sourceAccess.getLongPosition(d);
            }
        }

        @Override
        public int getIntPosition(int d) {
            return this.sourceAccess.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.sourceAccess.getLongPosition(d);
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                position[d] = this.sourceAccess.getFloatPosition(d);
            }
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                position[d] = this.sourceAccess.getDoublePosition(d);
            }
        }

        @Override
        public float getFloatPosition(int d) {
            return this.sourceAccess.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.sourceAccess.getFloatPosition(d);
        }

        @Override
        public int numDimensions() {
            return CompositeView.this.n;
        }

        @Override
        public void fwd(int d) {
            this.sourceAccess.fwd(d);
        }

        @Override
        public void bck(int d) {
            this.sourceAccess.bck(d);
        }

        @Override
        public void move(int distance, int d) {
            this.sourceAccess.move(distance, d);
        }

        @Override
        public void move(long distance, int d) {
            this.sourceAccess.move(distance, d);
        }

        @Override
        public void move(Localizable localizable) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.move(localizable.getLongPosition(d), d);
            }
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.move(distance[d], d);
            }
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.move(distance[d], d);
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.setPosition(localizable.getLongPosition(d), d);
            }
        }

        @Override
        public void setPosition(int[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.setPosition(position[d], d);
            }
        }

        @Override
        public void setPosition(long[] position) {
            for (int d = 0; d < CompositeView.this.n; ++d) {
                this.sourceAccess.setPosition(position[d], d);
            }
        }

        @Override
        public void setPosition(int position, int d) {
            this.sourceAccess.setPosition(position, d);
        }

        @Override
        public void setPosition(long position, int d) {
            this.sourceAccess.setPosition(position, d);
        }

        @Override
        public C get() {
            return this.composite;
        }

        public CompositeRandomAccess copy() {
            return new CompositeRandomAccess(this);
        }

        public CompositeRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }
}

