/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.imglib2.EuclideanSpace;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.Interpolant;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;
import net.imglib2.outofbounds.OutOfBoundsRandomValueFactory;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.transform.integer.permutation.AbstractPermutationTransform;
import net.imglib2.transform.integer.permutation.PermutationTransform;
import net.imglib2.transform.integer.permutation.SingleDimensionPermutationTransform;
import net.imglib2.transform.integer.shear.InverseShearTransform;
import net.imglib2.transform.integer.shear.ShearTransform;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.HyperSlicesView;
import net.imglib2.view.IntervalView;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.RandomAccessiblePair;
import net.imglib2.view.StackView;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.SubsampleView;
import net.imglib2.view.TransformView;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.CompositeView;
import net.imglib2.view.composite.GenericComposite;
import net.imglib2.view.composite.NumericComposite;
import net.imglib2.view.composite.RealComposite;

public class Views {
    public static <T, F extends EuclideanSpace> RealRandomAccessible<T> interpolate(F source, InterpolatorFactory<T, F> factory) {
        return new Interpolant<T, F>(source, factory);
    }

    public static <T> RandomAccessibleOnRealRandomAccessible<T> raster(RealRandomAccessible<T> source) {
        return new RandomAccessibleOnRealRandomAccessible<T>(source);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extend(F source, OutOfBoundsFactory<T, ? super F> factory) {
        return new ExtendedRandomAccessibleInterval<T, F>(source, factory);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorSingle(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorDouble(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE));
    }

    public static <T extends Type<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, T value) {
        return new ExtendedRandomAccessibleInterval<T, F>(source, new OutOfBoundsConstantValueFactory(value));
    }

    public static <T extends NumericType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendZero(F source) {
        NumericType zero = (NumericType)((NumericType)Util.getTypeFromInterval(source)).createVariable();
        zero.setZero();
        return new ExtendedRandomAccessibleInterval<NumericType, F>(source, new OutOfBoundsConstantValueFactory(zero));
    }

    public static <T extends RealType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendRandom(F source, double min, double max) {
        return new ExtendedRandomAccessibleInterval<RealType, F>(source, new OutOfBoundsRandomValueFactory((RealType)Util.getTypeFromInterval(source), min, max));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendPeriodic(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsPeriodicFactory());
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendBorder(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsBorderFactory());
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, long[] min, long[] max) {
        return new IntervalView<T>(randomAccessible, min, max);
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, Interval interval) {
        return new IntervalView<T>(randomAccessible, interval);
    }

    public static <T> MixedTransformView<T> rotate(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        MixedTransform t = new MixedTransform(n, n);
        if (fromAxis != toAxis) {
            int[] component = new int[n];
            boolean[] inv = new boolean[n];
            for (int e = 0; e < n; ++e) {
                if (e == toAxis) {
                    component[e] = fromAxis;
                    inv[e] = true;
                    continue;
                }
                component[e] = e == fromAxis ? toAxis : e;
            }
            t.setComponentMapping(component);
            t.setComponentInversion(inv);
        }
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> rotate(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        if (fromAxis != toAxis) {
            long fromMinNew = -max[toAxis];
            long fromMaxNew = -min[toAxis];
            min[toAxis] = min[fromAxis];
            max[toAxis] = max[fromAxis];
            min[fromAxis] = fromMinNew;
            max[fromAxis] = fromMaxNew;
        }
        return Views.interval(Views.rotate(interval, fromAxis, toAxis), min, max);
    }

    public static <T> MixedTransformView<T> permute(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        int[] component = new int[n];
        for (int e = 0; e < n; ++e) {
            component[e] = e;
        }
        component[fromAxis] = toAxis;
        component[toAxis] = fromAxis;
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(component);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> permute(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long fromMinNew = min[toAxis];
        long fromMaxNew = max[toAxis];
        min[toAxis] = min[fromAxis];
        max[toAxis] = max[fromAxis];
        min[fromAxis] = fromMinNew;
        max[fromAxis] = fromMaxNew;
        return Views.interval(Views.permute(interval, fromAxis, toAxis), min, max);
    }

    public static <T> MixedTransformView<T> translate(RandomAccessible<T> randomAccessible, long ... translation) {
        int n = randomAccessible.numDimensions();
        MixedTransform t = new MixedTransform(n, n);
        t.setInverseTranslation(translation);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> translate(RandomAccessibleInterval<T> interval, long ... translation) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] + translation[d];
            int n3 = d;
            max[n3] = max[n3] + translation[d];
        }
        return Views.interval(Views.translate(interval, translation), min, max);
    }

    public static <T> MixedTransformView<T> offset(RandomAccessible<T> randomAccessible, long ... offset) {
        int n = randomAccessible.numDimensions();
        MixedTransform t = new MixedTransform(n, n);
        t.setTranslation(offset);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> offset(RandomAccessibleInterval<T> interval, long ... offset) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] - offset[d];
            int n3 = d;
            max[n3] = max[n3] - offset[d];
        }
        return Views.interval(Views.offset(interval, offset), min, max);
    }

    public static <T> IntervalView<T> zeroMin(RandomAccessibleInterval<T> interval) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        long[] offset = new long[n];
        interval.min(offset);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            max[n2] = max[n2] - offset[d];
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setTranslation(offset);
        return Views.interval(new MixedTransformView<T>(interval, t), min, max);
    }

    public static <T> MixedTransformView<T> hyperSlice(RandomAccessible<T> view, int d, long pos) {
        int m = view.numDimensions();
        int n = m - 1;
        MixedTransform t = new MixedTransform(n, m);
        long[] translation = new long[m];
        translation[d] = pos;
        boolean[] zero = new boolean[m];
        int[] component = new int[m];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                zero[e] = false;
                component[e] = e;
                continue;
            }
            if (e > d) {
                zero[e] = false;
                component[e] = e - 1;
                continue;
            }
            zero[e] = true;
            component[e] = 0;
        }
        t.setTranslation(translation);
        t.setComponentZero(zero);
        t.setComponentMapping(component);
        return new MixedTransformView<T>(view, t);
    }

    public static <T> IntervalView<T> hyperSlice(RandomAccessibleInterval<T> view, int d, long pos) {
        int m = view.numDimensions();
        int n = m - 1;
        long[] min = new long[n];
        long[] max = new long[n];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                min[e] = view.min(e);
                max[e] = view.max(e);
                continue;
            }
            if (e <= d) continue;
            min[e - 1] = view.min(e);
            max[e - 1] = view.max(e);
        }
        return Views.interval(Views.hyperSlice(view, d, pos), min, max);
    }

    public static <T> MixedTransformView<T> addDimension(RandomAccessible<T> randomAccessible) {
        int m = randomAccessible.numDimensions();
        int n = m + 1;
        MixedTransform t = new MixedTransform(n, m);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> addDimension(RandomAccessibleInterval<T> interval, long minOfNewDim, long maxOfNewDim) {
        int m = interval.numDimensions();
        long[] min = new long[m + 1];
        long[] max = new long[m + 1];
        for (int d = 0; d < m; ++d) {
            min[d] = interval.min(d);
            max[d] = interval.max(d);
        }
        min[m] = minOfNewDim;
        max[m] = maxOfNewDim;
        return Views.interval(Views.addDimension(interval), min, max);
    }

    public static <T> MixedTransformView<T> invertAxis(RandomAccessible<T> randomAccessible, int d) {
        int n = randomAccessible.numDimensions();
        boolean[] inv = new boolean[n];
        inv[d] = true;
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentInversion(inv);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> invertAxis(RandomAccessibleInterval<T> interval, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long tmp = min[d];
        min[d] = -max[d];
        max[d] = -tmp;
        return Views.interval(Views.invertAxis(interval, d), min, max);
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, long[] offset, long[] dimension) {
        int n = randomAccessible.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            max[d] = dimension[d] - 1L;
        }
        return Views.interval(Views.offset(randomAccessible, offset), min, max);
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, Interval interval) {
        int n = randomAccessible.numDimensions();
        long[] offset = new long[n];
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(offset);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            max[n2] = max[n2] - offset[d];
        }
        return Views.interval(Views.offset(randomAccessible, offset), min, max);
    }

    public static boolean isZeroMin(Interval interval) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.min(d) == 0L) continue;
            return false;
        }
        return true;
    }

    public static <T> IterableInterval<T> iterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval)) {
            Object o;
            Class<?> raiType = Util.getTypeFromInterval(randomAccessibleInterval).getClass();
            Iterator iter = ((IterableInterval)((Object)randomAccessibleInterval)).iterator();
            Object v0 = o = iter.hasNext() ? iter.next() : null;
            if (raiType.isInstance(o)) {
                return (IterableInterval)((Object)randomAccessibleInterval);
            }
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> IterableInterval<T> flatIterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval) && FlatIterationOrder.class.isInstance(((IterableInterval)((Object)randomAccessibleInterval)).iterationOrder())) {
            Object o;
            Class<?> raiType = Util.getTypeFromInterval(randomAccessibleInterval).getClass();
            Iterator iter = ((IterableInterval)((Object)randomAccessibleInterval)).iterator();
            Object v0 = o = iter.hasNext() ? iter.next() : null;
            if (raiType.isInstance(o)) {
                return (IterableInterval)((Object)randomAccessibleInterval);
            }
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> CompositeIntervalView<T, ? extends GenericComposite<T>> collapse(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeIntervalView<T, RealComposite<T>> collapseReal(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new RealComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T extends NumericType<T>> CompositeIntervalView<T, NumericComposite<T>> collapseNumeric(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new NumericComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T> CompositeView<T, ? extends GenericComposite<T>> collapse(RandomAccessible<T> source) {
        return new CompositeView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeView<T, RealComposite<T>> collapseReal(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new RealComposite.Factory(numChannels));
    }

    public static <T extends NumericType<T>> CompositeView<T, NumericComposite<T>> collapseNumeric(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new NumericComposite.Factory(numChannels));
    }

    public static <T> SubsampleIntervalView<T> subsample(RandomAccessibleInterval<T> source, long step) {
        return new SubsampleIntervalView<T>(source, step);
    }

    public static <T> SubsampleIntervalView<T> subsample(RandomAccessibleInterval<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleIntervalView<T>(source, steps);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long step) {
        return new SubsampleView<T>(source, step);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleView<T>(source, steps);
    }

    public static <T> RandomAccessibleInterval<T> dropSingletonDimensions(RandomAccessibleInterval<T> source) {
        RandomAccessibleInterval<T> res = source;
        for (int d = source.numDimensions() - 1; d >= 0; --d) {
            if (source.dimension(d) != 1L) continue;
            res = Views.hyperSlice(res, d, source.min(d));
        }
        return res;
    }

    public static <T> RandomAccessibleInterval<T> stack(List<? extends RandomAccessibleInterval<T>> hyperslices) {
        return new StackView(hyperslices);
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> stack(RandomAccessibleInterval<T> ... hyperslices) {
        return new StackView<T>(Arrays.asList(hyperslices));
    }

    public static <T> RandomAccessibleInterval<T> stack(StackView.StackAccessMode stackAccessMode, List<? extends RandomAccessibleInterval<T>> hyperslices) {
        return new StackView(hyperslices, stackAccessMode);
    }

    public static <T> RandomAccessibleInterval<T> stack(StackView.StackAccessMode stackAccessMode, RandomAccessibleInterval<T> ... hyperslices) {
        return new StackView<T>(Arrays.asList(hyperslices), stackAccessMode);
    }

    public static <T> TransformView<T> shear(RandomAccessible<T> source, int shearDimension, int referenceDimension) {
        ShearTransform transform = new ShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return new TransformView<T>(source, transform.inverse());
    }

    public static <T> TransformView<T> unshear(RandomAccessible<T> source, int shearDimension, int referenceDimension) {
        InverseShearTransform transform = new InverseShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return new TransformView<T>(source, transform.inverse());
    }

    public static <T> IntervalView<T> shear(RandomAccessible<T> source, Interval interval, int shearDimension, int referenceDimension) {
        ShearTransform transform = new ShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return Views.interval(Views.shear(source, shearDimension, referenceDimension), transform.transform(new BoundingBox(interval)).getInterval());
    }

    public static <T> IntervalView<T> unshear(RandomAccessible<T> source, Interval interval, int shearDimension, int referenceDimension) {
        InverseShearTransform transform = new InverseShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return Views.interval(Views.unshear(source, shearDimension, referenceDimension), transform.transform(new BoundingBox(interval)).getInterval());
    }

    public static <T> IntervalView<T> permuteCoordinates(RandomAccessibleInterval<T> source, int[] permutation) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (PermutationTransform.checkInterval(source, permutation)) : "Source interval boundaries do not match permutation.";
        int nDim = source.numDimensions();
        PermutationTransform transform = new PermutationTransform(permutation, nDim, nDim);
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <T> IntervalView<T> permuteCoordinates(RandomAccessibleInterval<T> source, int[] permutation, int d) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (source.min(d) == 0L) : "Source with min[d] coordinate != 0 passed to coordinate permutation.";
        assert (source.dimension(d) == (long)permutation.length) : "Source with dimension[d] != LUT.length passed to coordinate permutation.";
        int nDim = source.numDimensions();
        SingleDimensionPermutationTransform transform = new SingleDimensionPermutationTransform(permutation, nDim, nDim, d);
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <T> IntervalView<T> permuteCoordinatesInverse(RandomAccessibleInterval<T> source, int[] permutation) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (PermutationTransform.checkInterval(source, permutation)) : "Source interval boundaries do not match permutation.";
        int nDim = source.numDimensions();
        PermutationTransform transform = new PermutationTransform(permutation, nDim, nDim).inverse();
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <T> IntervalView<T> permuteCoordinateInverse(RandomAccessibleInterval<T> source, int[] permutation, int d) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (source.min(d) == 0L) : "Source with min[d] coordinate != 0 passed to coordinate permutation.";
        assert (source.dimension(d) == (long)permutation.length) : "Source with dimension[d] != LUT.length passed to coordinate permutation.";
        int nDim = source.numDimensions();
        SingleDimensionPermutationTransform transform = new SingleDimensionPermutationTransform(permutation, nDim, nDim, d).inverse();
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <A, B> RandomAccessible<Pair<A, B>> pair(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB) {
        return new RandomAccessiblePair<A, B>(sourceA, sourceB);
    }

    public static <T> RandomAccessible<? extends RandomAccessible<T>> hyperSlices(RandomAccessible<T> source, int ... axes) {
        return new HyperSlicesView<T>(source, axes);
    }

    public static <T, F extends RandomAccessibleInterval<T>> IntervalView<T> expand(F source, OutOfBoundsFactory<T, ? super F> oob, long ... border) {
        return Views.interval(Views.extend(source, oob), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandMirrorSingle(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendMirrorSingle(source), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandMirrorDouble(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendMirrorDouble(source), Intervals.expand(source, border));
    }

    public static <T extends Type<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, T t, long ... border) {
        return Views.interval(Views.extendValue(source, t), Intervals.expand(source, border));
    }

    public static <T extends NumericType<T>> IntervalView<T> expandZero(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendZero(source), Intervals.expand(source, border));
    }

    public static <T extends RealType<T>> IntervalView<T> expandRandom(RandomAccessibleInterval<T> source, double min, double max, long ... border) {
        return Views.interval(Views.extendRandom(source, min, max), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandPeriodic(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendPeriodic(source), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandBorder(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendBorder(source), Intervals.expand(source, border));
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, RandomAccessibleInterval<T> ... sources) {
        return Views.concatenate(concatenationAxis, StackView.StackAccessMode.DEFAULT, sources);
    }

    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, List<? extends RandomAccessibleInterval<T>> sources) {
        return Views.concatenate(concatenationAxis, StackView.StackAccessMode.DEFAULT, sources);
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, StackView.StackAccessMode mode, RandomAccessibleInterval<T> ... sources) {
        return Views.concatenate(concatenationAxis, mode, Arrays.asList(sources));
    }

    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, StackView.StackAccessMode mode, List<? extends RandomAccessibleInterval<T>> sources) {
        assert (sources.size() > 0);
        ArrayList<IntervalView<T>> hyperSlices = new ArrayList<IntervalView<T>>();
        for (RandomAccessibleInterval<T> source : sources) {
            for (long index = source.min(concatenationAxis); index <= source.max(concatenationAxis); ++index) {
                hyperSlices.add(Views.hyperSlice(source, concatenationAxis, index));
            }
        }
        return Views.stack(mode, hyperSlices);
    }
}

