/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealPoint;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.view.Views;

public class ConstantUtils {
    public static <T> RandomAccessible<T> constantRandomAccessible(final T constant, final int numDimensions) {
        return new RandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return numDimensions;
            }

            @Override
            public RandomAccess<T> randomAccess() {
                return new ConstantRandomAccess();
            }

            @Override
            public RandomAccess<T> randomAccess(Interval interval) {
                return this.randomAccess();
            }

            final class ConstantRandomAccess
            extends Point
            implements RandomAccess<T> {
                public ConstantRandomAccess() {
                    super(numDimensions);
                }

                @Override
                public T get() {
                    return constant;
                }

                public ConstantRandomAccess copy() {
                    return new ConstantRandomAccess();
                }

                public ConstantRandomAccess copyRandomAccess() {
                    return this.copy();
                }
            }
        };
    }

    public static <T> RandomAccessibleInterval<T> constantRandomAccessibleInterval(T constant, int numDimensions, Interval interval) {
        return Views.interval(ConstantUtils.constantRandomAccessible(constant, numDimensions), interval);
    }

    public static <T> RealRandomAccessible<T> constantRealRandomAccessible(final T constant, final int numDimensions) {
        return new RealRandomAccessible<T>(){

            @Override
            public int numDimensions() {
                return numDimensions;
            }

            public ConstantRealRandomAccess realRandomAccess() {
                return new ConstantRealRandomAccess();
            }

            public ConstantRealRandomAccess realRandomAccess(RealInterval interval) {
                return this.realRandomAccess();
            }

            final class ConstantRealRandomAccess
            extends RealPoint
            implements RealRandomAccess<T> {
                public ConstantRealRandomAccess() {
                    super(numDimensions);
                }

                @Override
                public T get() {
                    return constant;
                }

                public ConstantRealRandomAccess copy() {
                    return new ConstantRealRandomAccess();
                }

                public ConstantRealRandomAccess copyRealRandomAccess() {
                    return this.copy();
                }
            }
        };
    }
}

