/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

public final class Ntree<T extends Comparable<T>> {
    final int n;
    final int numTreeLevels;
    final int numChildren;
    NtreeNode<T> root;
    final long[] dimensions;

    public Ntree(long[] dimensions, T value) {
        this.n = dimensions.length;
        this.dimensions = (long[])dimensions.clone();
        long maxdim = 0L;
        for (int d = 0; d < this.n; ++d) {
            maxdim = Math.max(maxdim, dimensions[d]);
        }
        this.numTreeLevels = (int)Math.ceil(Math.log(maxdim) / Math.log(2.0)) + 1;
        this.numChildren = 1 << this.n;
        this.root = new NtreeNode<T>(null, value);
    }

    private NtreeNode<T> copyRecursively(NtreeNode<T> node, NtreeNode<T> newParent) {
        NtreeNode<T> copy = new NtreeNode<T>(newParent, node.getValue());
        if (node.hasChildren()) {
            NtreeNode.access$002(copy, new NtreeNode[this.numChildren]);
            for (int i = 0; i < this.numChildren; ++i) {
                ((NtreeNode)copy).children[i] = this.copyRecursively(((NtreeNode)node).children[i], copy);
            }
        }
        return copy;
    }

    Ntree(Ntree<T> ntree) {
        this.dimensions = ntree.dimensions;
        this.n = ntree.n;
        this.numTreeLevels = ntree.numTreeLevels;
        this.numChildren = ntree.numChildren;
        this.root = this.copyRecursively(ntree.root, null);
    }

    synchronized NtreeNode<T> getNode(long[] position) {
        NtreeNode current = this.root;
        for (int l = this.numTreeLevels - 2; l >= 0 && current.hasChildren(); --l) {
            long bitmask = 1 << l;
            int childindex = 0;
            for (int d = 0; d < this.n; ++d) {
                if ((position[d] & bitmask) == 0L) continue;
                childindex |= 1 << d;
            }
            current = current.children[childindex];
        }
        return current;
    }

    synchronized NtreeNode<T> createNode(long[] position) {
        NtreeNode current = this.root;
        for (int l = this.numTreeLevels - 2; l >= 0; --l) {
            if (!current.hasChildren()) {
                NtreeNode.access$002(current, new NtreeNode[this.numChildren]);
                for (int i = 0; i < this.numChildren; ++i) {
                    current.children[i] = new NtreeNode(current, current.getValue());
                }
            }
            long bitmask = 1 << l;
            int childindex = 0;
            for (int d = 0; d < this.n; ++d) {
                if ((position[d] & bitmask) == 0L) continue;
                childindex |= 1 << d;
            }
            current = current.children[childindex];
        }
        return current;
    }

    synchronized NtreeNode<T> createNodeWithValue(long[] position, T value) {
        NtreeNode current = this.root;
        for (int l = this.numTreeLevels - 2; l >= 0; --l) {
            if (!current.hasChildren()) {
                if (((Comparable)current.getValue()).compareTo(value) == 0) {
                    return current;
                }
                NtreeNode.access$002(current, new NtreeNode[this.numChildren]);
                for (int i = 0; i < this.numChildren; ++i) {
                    ((NtreeNode)current).children[i] = new NtreeNode(current, current.getValue());
                }
            }
            long bitmask = 1 << l;
            int childindex = 0;
            for (int d = 0; d < this.n; ++d) {
                if ((position[d] & bitmask) == 0L) continue;
                childindex |= 1 << d;
            }
            current = current.children[childindex];
        }
        if (((Comparable)current.getValue()).compareTo(value) == 0) {
            return current;
        }
        current.setValue(value);
        return this.mergeUpwards(current);
    }

    NtreeNode<T> mergeUpwards(NtreeNode<T> node) {
        NtreeNode parent = ((NtreeNode)node).parent;
        if (parent == null) {
            return node;
        }
        NtreeNode child0 = parent.children[0];
        if (child0.hasChildren()) {
            return node;
        }
        for (int i = 1; i < this.numChildren; ++i) {
            NtreeNode child = parent.children[i];
            if (!child.hasChildren() && ((Comparable)child0.getValue()).compareTo(child.getValue()) == 0) continue;
            return node;
        }
        parent.setValue(child0.getValue());
        NtreeNode.access$002(parent, null);
        return this.mergeUpwards(parent);
    }

    public NtreeNode<T> getRootNode() {
        return this.root;
    }

    public static final class NtreeNode<T> {
        private T value;
        private final NtreeNode<T> parent;
        private NtreeNode<T>[] children;

        public NtreeNode(NtreeNode<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        boolean hasChildren() {
            return this.children != null;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public NtreeNode<T>[] getChildren() {
            return this.children;
        }

        public void setChildren(NtreeNode<T>[] children) {
            this.children = children;
        }

        static /* synthetic */ NtreeNode[] access$002(NtreeNode x0, NtreeNode[] x1) {
            x0.children = x1;
            return x1;
        }
    }
}

