/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellIterationOrder;
import net.imglib2.img.cell.CellLocalizingCursor;
import net.imglib2.img.cell.CellRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Fraction;

public abstract class AbstractCellImg<T extends NativeType<T>, A, C extends Cell<A>, I extends RandomAccessible<C> & IterableInterval<C>>
extends AbstractNativeImg<T, A> {
    protected final CellGrid grid;
    protected final I cells;

    public AbstractCellImg(CellGrid grid, I imgOfCells, Fraction entitiesPerPixel) {
        super(grid.getImgDimensions(), entitiesPerPixel);
        this.grid = grid;
        this.cells = imgOfCells;
    }

    @Override
    public A update(Object cursor) {
        return ((Cell)((CellImgSampler)cursor).getCell()).getData();
    }

    @Override
    public CellCursor<T, C> cursor() {
        return new CellCursor(this);
    }

    @Override
    public CellLocalizingCursor<T, C> localizingCursor() {
        return new CellLocalizingCursor(this);
    }

    public CellRandomAccess<T, C> randomAccess() {
        return new CellRandomAccess(this);
    }

    @Override
    public CellIterationOrder iterationOrder() {
        return new CellIterationOrder(this);
    }

    public I getCells() {
        return this.cells;
    }

    public CellGrid getCellGrid() {
        return this.grid;
    }

    protected void copyDataTo(AbstractCellImg<T, ?, ?, ?> copy) {
        Cursor source = this.cursor();
        Cursor target = copy.cursor();
        while (((CellCursor)source).hasNext()) {
            ((NativeType)((AbstractCursor)target).next()).set((Type)((AbstractCursor)source).next());
        }
    }

    public static interface CellImgSampler<C> {
        public C getCell();
    }
}

