/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.display.ArrayColorTable;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Binning;

public abstract class AbstractArrayColorTable<T>
implements ArrayColorTable<T> {
    protected final T[] values;

    public AbstractArrayColorTable(T ... values) {
        this.values = values;
    }

    @Override
    public T[] getValues() {
        return (Object[])this.values.clone();
    }

    @Override
    public int argb(int i) {
        int r = this.values.length > 0 ? this.get(0, i) : 0;
        int g = this.values.length > 1 ? this.get(1, i) : 0;
        int b = this.values.length > 2 ? this.get(2, i) : 0;
        int a = this.values.length > 3 ? this.get(3, i) : 255;
        return ARGBType.rgba(r, g, b, a);
    }

    @Override
    public int lookupARGB(double min, double max, double value) {
        int bins = this.getLength();
        int bin = Binning.valueToBin(bins, min, max, value);
        return this.argb(bin);
    }

    @Override
    public int getComponentCount() {
        return this.values.length;
    }

    @Override
    public abstract int get(int var1, int var2);

    @Override
    public abstract int getResampled(int var1, int var2, int var3);
}

