/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import net.imglib2.converter.Converter;
import net.imglib2.display.AbstractLinearRange;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;

public class RealARGBConverter<R extends RealType<?>>
extends AbstractLinearRange
implements Converter<R, ARGBType> {
    public RealARGBConverter() {
    }

    public RealARGBConverter(double min, double max) {
        super(min, max);
    }

    @Override
    public void convert(R input, ARGBType output) {
        double a = input.getRealDouble();
        int b = Math.min(255, RealARGBConverter.roundPositive(Math.max(0.0, (a - this.min) / this.scale * 255.0)));
        int argb = 0xFF000000 | (b << 8 | b) << 8 | b;
        output.set(argb);
    }
}

