/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.scalar.ComplexNumber;

public abstract class EvD1D {
    public static double[][] hqr2(double[] mtrxH, double[] mtrxV, boolean allTheWay) {
        int tmpDiagDim = (int)PrimitiveFunction.SQRT.invoke(mtrxH.length);
        int tmpDiagDimMinusOne = tmpDiagDim - 1;
        double tmpVal = PrimitiveMath.ZERO;
        for (int j = 0; j < tmpDiagDim; ++j) {
            for (int i = Math.min(j + 1, tmpDiagDim - 1); i >= 0; --i) {
                tmpVal += PrimitiveFunction.ABS.invoke(mtrxH[i + tmpDiagDim * j]);
            }
        }
        double tmpNorm1 = tmpVal;
        double[] d = new double[tmpDiagDim];
        double[] e = new double[tmpDiagDim];
        double exshift = PrimitiveMath.ZERO;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        int tmpIterCount = 0;
        int tmpMainIterIndex = tmpDiagDimMinusOne;
        while (tmpMainIterIndex >= 0) {
            int m;
            int i;
            double x;
            double w;
            int l;
            for (l = tmpMainIterIndex; l > 0; --l) {
                s = PrimitiveFunction.ABS.invoke(mtrxH[l - 1 + tmpDiagDim * (l - 1)]) + PrimitiveFunction.ABS.invoke(mtrxH[l + tmpDiagDim * l]);
                if (Double.compare(s, PrimitiveMath.ZERO) == 0) {
                    s = tmpNorm1;
                }
                if (PrimitiveFunction.ABS.invoke(mtrxH[l + tmpDiagDim * (l - 1)]) < PrimitiveMath.MACHINE_EPSILON * s) break;
            }
            if (l == tmpMainIterIndex) {
                mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] = mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] + exshift;
                d[tmpMainIterIndex] = mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
                e[tmpMainIterIndex] = PrimitiveMath.ZERO;
                --tmpMainIterIndex;
                tmpIterCount = 0;
                continue;
            }
            if (l == tmpMainIterIndex - 1) {
                w = mtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)] * mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * tmpMainIterIndex];
                p = (mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] - mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex]) / 2.0;
                q = p * p + w;
                z = PrimitiveFunction.SQRT.invoke(PrimitiveFunction.ABS.invoke(q));
                mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] = mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] + exshift;
                mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] = mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] + exshift;
                x = mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    d[tmpMainIterIndex - 1] = x + z;
                    d[tmpMainIterIndex] = d[tmpMainIterIndex - 1];
                    if (Double.compare(z, PrimitiveMath.ZERO) != 0) {
                        d[tmpMainIterIndex] = x - w / z;
                    }
                    e[tmpMainIterIndex - 1] = PrimitiveMath.ZERO;
                    e[tmpMainIterIndex] = PrimitiveMath.ZERO;
                    x = mtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)];
                    s = PrimitiveFunction.ABS.invoke(x) + PrimitiveFunction.ABS.invoke(z);
                    p = x / s;
                    q = z / s;
                    r = PrimitiveFunction.SQRT.invoke(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j = tmpMainIterIndex - 1; j < tmpDiagDim; ++j) {
                        z = mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * j];
                        mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * j] = q * z + p * mtrxH[tmpMainIterIndex + tmpDiagDim * j];
                        mtrxH[tmpMainIterIndex + tmpDiagDim * j] = q * mtrxH[tmpMainIterIndex + tmpDiagDim * j] - p * z;
                    }
                    for (i = 0; i <= tmpMainIterIndex; ++i) {
                        z = mtrxH[i + tmpDiagDim * (tmpMainIterIndex - 1)];
                        mtrxH[i + tmpDiagDim * (tmpMainIterIndex - 1)] = q * z + p * mtrxH[i + tmpDiagDim * tmpMainIterIndex];
                        mtrxH[i + tmpDiagDim * tmpMainIterIndex] = q * mtrxH[i + tmpDiagDim * tmpMainIterIndex] - p * z;
                    }
                    for (i = 0; i <= tmpDiagDimMinusOne; ++i) {
                        z = mtrxV[i + tmpDiagDim * (tmpMainIterIndex - 1)];
                        mtrxV[i + tmpDiagDim * (tmpMainIterIndex - 1)] = q * z + p * mtrxV[i + tmpDiagDim * tmpMainIterIndex];
                        mtrxV[i + tmpDiagDim * tmpMainIterIndex] = q * mtrxV[i + tmpDiagDim * tmpMainIterIndex] - p * z;
                    }
                } else {
                    d[tmpMainIterIndex - 1] = x + p;
                    d[tmpMainIterIndex] = x + p;
                    e[tmpMainIterIndex - 1] = z;
                    e[tmpMainIterIndex] = -z;
                }
                tmpMainIterIndex -= 2;
                tmpIterCount = 0;
                continue;
            }
            x = mtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
            double y = PrimitiveMath.ZERO;
            w = PrimitiveMath.ZERO;
            if (l < tmpMainIterIndex) {
                y = mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)];
                w = mtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)] * mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * tmpMainIterIndex];
            }
            if (tmpIterCount == 10) {
                exshift += x;
                for (i = 0; i <= tmpMainIterIndex; ++i) {
                    int n = i + tmpDiagDim * i;
                    mtrxH[n] = mtrxH[n] - x;
                }
                s = PrimitiveFunction.ABS.invoke(mtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)]) + PrimitiveFunction.ABS.invoke(mtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 2)]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (tmpIterCount == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = PrimitiveFunction.SQRT.invoke(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = 0; i <= tmpMainIterIndex; ++i) {
                        int n = i + tmpDiagDim * i;
                        mtrxH[n] = mtrxH[n] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++tmpIterCount;
            for (m = tmpMainIterIndex - 2; m >= l; --m) {
                z = mtrxH[m + tmpDiagDim * m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / mtrxH[m + 1 + tmpDiagDim * m] + mtrxH[m + tmpDiagDim * (m + 1)];
                q = mtrxH[m + 1 + tmpDiagDim * (m + 1)] - z - r - s;
                r = mtrxH[m + 2 + tmpDiagDim * (m + 1)];
                s = PrimitiveFunction.ABS.invoke(p) + PrimitiveFunction.ABS.invoke(q) + PrimitiveFunction.ABS.invoke(r);
                if (m == l || PrimitiveFunction.ABS.invoke(mtrxH[m + tmpDiagDim * (m - 1)]) * (PrimitiveFunction.ABS.invoke(q /= s) + PrimitiveFunction.ABS.invoke(r /= s)) < PrimitiveMath.MACHINE_EPSILON * (PrimitiveFunction.ABS.invoke(p /= s) * (PrimitiveFunction.ABS.invoke(mtrxH[m - 1 + tmpDiagDim * (m - 1)]) + PrimitiveFunction.ABS.invoke(z) + PrimitiveFunction.ABS.invoke(mtrxH[m + 1 + tmpDiagDim * (m + 1)])))) break;
            }
            for (int i2 = m + 2; i2 <= tmpMainIterIndex; ++i2) {
                mtrxH[i2 + tmpDiagDim * (i2 - 2)] = PrimitiveMath.ZERO;
                if (i2 <= m + 2) continue;
                mtrxH[i2 + tmpDiagDim * (i2 - 3)] = PrimitiveMath.ZERO;
            }
            for (int k = m; k <= tmpMainIterIndex - 1; ++k) {
                int i3;
                boolean notlast;
                boolean bl = notlast = k != tmpMainIterIndex - 1;
                if (k != m) {
                    p = mtrxH[k + tmpDiagDim * (k - 1)];
                    q = mtrxH[k + 1 + tmpDiagDim * (k - 1)];
                    r = notlast ? mtrxH[k + 2 + tmpDiagDim * (k - 1)] : PrimitiveMath.ZERO;
                    x = PrimitiveFunction.ABS.invoke(p) + PrimitiveFunction.ABS.invoke(q) + PrimitiveFunction.ABS.invoke(r);
                    if (Double.compare(x, PrimitiveMath.ZERO) == 0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = PrimitiveFunction.SQRT.invoke(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    mtrxH[k + tmpDiagDim * (k - 1)] = -s * x;
                } else if (l != m) {
                    mtrxH[k + tmpDiagDim * (k - 1)] = -mtrxH[k + tmpDiagDim * (k - 1)];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j = k; j < tmpDiagDim; ++j) {
                    p = mtrxH[k + tmpDiagDim * j] + q * mtrxH[k + 1 + tmpDiagDim * j];
                    if (notlast) {
                        mtrxH[k + 2 + tmpDiagDim * j] = mtrxH[k + 2 + tmpDiagDim * j] - (p += r * mtrxH[k + 2 + tmpDiagDim * j]) * z;
                    }
                    mtrxH[k + tmpDiagDim * j] = mtrxH[k + tmpDiagDim * j] - p * x;
                    mtrxH[k + 1 + tmpDiagDim * j] = mtrxH[k + 1 + tmpDiagDim * j] - p * y;
                }
                for (i3 = 0; i3 <= Math.min(tmpMainIterIndex, k + 3); ++i3) {
                    p = x * mtrxH[i3 + tmpDiagDim * k] + y * mtrxH[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        mtrxH[i3 + tmpDiagDim * (k + 2)] = mtrxH[i3 + tmpDiagDim * (k + 2)] - (p += z * mtrxH[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    mtrxH[i3 + tmpDiagDim * k] = mtrxH[i3 + tmpDiagDim * k] - p;
                    mtrxH[i3 + tmpDiagDim * (k + 1)] = mtrxH[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
                for (i3 = 0; i3 <= tmpDiagDimMinusOne; ++i3) {
                    p = x * mtrxV[i3 + tmpDiagDim * k] + y * mtrxV[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        mtrxV[i3 + tmpDiagDim * (k + 2)] = mtrxV[i3 + tmpDiagDim * (k + 2)] - (p += z * mtrxV[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    mtrxV[i3 + tmpDiagDim * k] = mtrxV[i3 + tmpDiagDim * k] - p;
                    mtrxV[i3 + tmpDiagDim * (k + 1)] = mtrxV[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
            }
        }
        if (allTheWay && Double.compare(tmpNorm1, PrimitiveMath.ZERO) != 0) {
            int tmpDiagDimMinusOne1;
            int tmpDiagDim1 = (int)PrimitiveFunction.SQRT.invoke(mtrxH.length);
            for (int ij = tmpDiagDimMinusOne1 = tmpDiagDim1 - 1; ij >= 0; --ij) {
                double t;
                double y1;
                double x1;
                double w1;
                int i;
                int l;
                double p1 = d[ij];
                double q1 = e[ij];
                if (q1 == 0.0) {
                    l = ij;
                    mtrxH[ij + tmpDiagDim1 * ij] = 1.0;
                    for (i = ij - 1; i >= 0; --i) {
                        int j;
                        w1 = mtrxH[i + tmpDiagDim1 * i] - p1;
                        r = PrimitiveMath.ZERO;
                        for (j = l; j <= ij; ++j) {
                            r += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * ij];
                        }
                        if (e[i] < PrimitiveMath.ZERO) {
                            z = w1;
                            s = r;
                            continue;
                        }
                        l = i;
                        if (e[i] == PrimitiveMath.ZERO) {
                            mtrxH[i + tmpDiagDim1 * ij] = Double.compare(w1, PrimitiveMath.ZERO) != 0 ? -r / w1 : -r / (PrimitiveMath.MACHINE_EPSILON * tmpNorm1);
                        } else {
                            x1 = mtrxH[i + tmpDiagDim1 * (i + 1)];
                            y1 = mtrxH[i + 1 + tmpDiagDim1 * i];
                            q1 = (d[i] - p1) * (d[i] - p1) + e[i] * e[i];
                            mtrxH[i + tmpDiagDim1 * ij] = t = (x1 * s - z * r) / q1;
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = PrimitiveFunction.ABS.invoke(x1) > PrimitiveFunction.ABS.invoke(z) ? (-r - w1 * t) / x1 : (-s - y1 * t) / z;
                        }
                        t = PrimitiveFunction.ABS.invoke(mtrxH[i + tmpDiagDim1 * ij]);
                        if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                        for (j = i; j <= ij; ++j) {
                            mtrxH[j + tmpDiagDim1 * ij] = mtrxH[j + tmpDiagDim1 * ij] / t;
                        }
                    }
                    continue;
                }
                if (!(q1 < 0.0)) continue;
                l = ij - 1;
                if (PrimitiveFunction.ABS.invoke(mtrxH[ij + tmpDiagDim1 * (ij - 1)]) > PrimitiveFunction.ABS.invoke(mtrxH[ij - 1 + tmpDiagDim1 * ij])) {
                    mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] = q1 / mtrxH[ij + tmpDiagDim1 * (ij - 1)];
                    mtrxH[ij - 1 + tmpDiagDim1 * ij] = -(mtrxH[ij + tmpDiagDim1 * ij] - p1) / mtrxH[ij + tmpDiagDim1 * (ij - 1)];
                } else {
                    ComplexNumber tmpX = ComplexNumber.of(PrimitiveMath.ZERO, -mtrxH[ij - 1 + tmpDiagDim1 * ij]);
                    double imaginary = q1;
                    ComplexNumber tmpY = ComplexNumber.of(mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] - p1, imaginary);
                    ComplexNumber tmpZ = tmpX.divide(tmpY);
                    mtrxH[ij - 1 + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                    mtrxH[ij - 1 + tmpDiagDim1 * ij] = tmpZ.i;
                }
                mtrxH[ij + tmpDiagDim1 * (ij - 1)] = PrimitiveMath.ZERO;
                mtrxH[ij + tmpDiagDim1 * ij] = 1.0;
                for (i = ij - 2; i >= 0; --i) {
                    ComplexNumber tmpZ;
                    ComplexNumber tmpY;
                    double imaginary;
                    double real;
                    ComplexNumber tmpX;
                    double ra = PrimitiveMath.ZERO;
                    double sa = PrimitiveMath.ZERO;
                    for (int j = l; j <= ij; ++j) {
                        ra += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * (ij - 1)];
                        sa += mtrxH[i + tmpDiagDim1 * j] * mtrxH[j + tmpDiagDim1 * ij];
                    }
                    w1 = mtrxH[i + tmpDiagDim1 * i] - p1;
                    if (e[i] < PrimitiveMath.ZERO) {
                        z = w1;
                        r = ra;
                        s = sa;
                        continue;
                    }
                    l = i;
                    if (e[i] == 0.0) {
                        tmpX = ComplexNumber.of(-ra, -sa);
                        real = w1;
                        imaginary = q1;
                        tmpY = ComplexNumber.of(real, imaginary);
                        tmpZ = tmpX.divide(tmpY);
                        mtrxH[i + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                        mtrxH[i + tmpDiagDim1 * ij] = tmpZ.i;
                    } else {
                        x1 = mtrxH[i + tmpDiagDim1 * (i + 1)];
                        y1 = mtrxH[i + 1 + tmpDiagDim1 * i];
                        double vr = (d[i] - p1) * (d[i] - p1) + e[i] * e[i] - q1 * q1;
                        double vi = (d[i] - p1) * 2.0 * q1;
                        if (Double.compare(vr, PrimitiveMath.ZERO) == 0 && Double.compare(vi, PrimitiveMath.ZERO) == 0) {
                            vr = PrimitiveMath.MACHINE_EPSILON * tmpNorm1 * (PrimitiveFunction.ABS.invoke(w1) + PrimitiveFunction.ABS.invoke(q1) + PrimitiveFunction.ABS.invoke(x1) + PrimitiveFunction.ABS.invoke(y1) + PrimitiveFunction.ABS.invoke(z));
                        }
                        tmpX = ComplexNumber.of(x1 * r - z * ra + q1 * sa, x1 * s - z * sa - q1 * ra);
                        real = vr;
                        imaginary = vi;
                        tmpY = ComplexNumber.of(real, imaginary);
                        tmpZ = tmpX.divide(tmpY);
                        mtrxH[i + tmpDiagDim1 * (ij - 1)] = tmpZ.doubleValue();
                        mtrxH[i + tmpDiagDim1 * ij] = tmpZ.i;
                        if (PrimitiveFunction.ABS.invoke(x1) > PrimitiveFunction.ABS.invoke(z) + PrimitiveFunction.ABS.invoke(q1)) {
                            mtrxH[i + 1 + tmpDiagDim1 * (ij - 1)] = (-ra - w1 * mtrxH[i + tmpDiagDim1 * (ij - 1)] + q1 * mtrxH[i + tmpDiagDim1 * ij]) / x1;
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = (-sa - w1 * mtrxH[i + tmpDiagDim1 * ij] - q1 * mtrxH[i + tmpDiagDim1 * (ij - 1)]) / x1;
                        } else {
                            ComplexNumber tmpX1 = ComplexNumber.of(-r - y1 * mtrxH[i + tmpDiagDim1 * (ij - 1)], -s - y1 * mtrxH[i + tmpDiagDim1 * ij]);
                            double real1 = z;
                            double imaginary1 = q1;
                            ComplexNumber tmpY1 = ComplexNumber.of(real1, imaginary1);
                            ComplexNumber tmpZ1 = tmpX1.divide(tmpY1);
                            mtrxH[i + 1 + tmpDiagDim1 * (ij - 1)] = tmpZ1.doubleValue();
                            mtrxH[i + 1 + tmpDiagDim1 * ij] = tmpZ1.i;
                        }
                    }
                    t = PrimitiveFunction.MAX.invoke(PrimitiveFunction.ABS.invoke(mtrxH[i + tmpDiagDim1 * (ij - 1)]), PrimitiveFunction.ABS.invoke(mtrxH[i + tmpDiagDim1 * ij]));
                    if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                    for (int j = i; j <= ij; ++j) {
                        mtrxH[j + tmpDiagDim1 * (ij - 1)] = mtrxH[j + tmpDiagDim1 * (ij - 1)] / t;
                        mtrxH[j + tmpDiagDim1 * ij] = mtrxH[j + tmpDiagDim1 * ij] / t;
                    }
                }
            }
            for (int j = tmpDiagDimMinusOne1; j >= 0; --j) {
                for (int i = 0; i <= tmpDiagDimMinusOne1; ++i) {
                    z = PrimitiveMath.ZERO;
                    for (int k = 0; k <= j; ++k) {
                        z += mtrxV[i + tmpDiagDim1 * k] * mtrxH[k + tmpDiagDim1 * j];
                    }
                    mtrxV[i + tmpDiagDim1 * j] = z;
                }
            }
        }
        return new double[][]{d, e};
    }

    public static void orthes(double[] mtrxH, double[] trnspV, double[] vctrWork) {
        int ij;
        int size = vctrWork.length;
        int sizeM1 = size - 1;
        int sizeM2 = size - 2;
        for (ij = 0; ij < sizeM2; ++ij) {
            double f;
            int m = ij + 1;
            double tmpColNorm1 = PrimitiveMath.ZERO;
            for (int i = m; i < size; ++i) {
                tmpColNorm1 += PrimitiveFunction.ABS.invoke(mtrxH[i + size * ij]);
            }
            if (Double.compare(tmpColNorm1, PrimitiveMath.ZERO) == 0) continue;
            double tmpInvBeta = PrimitiveMath.ZERO;
            for (int i = sizeM1; i >= m; --i) {
                vctrWork[i] = mtrxH[i + size * ij] / tmpColNorm1;
                tmpInvBeta += vctrWork[i] * vctrWork[i];
            }
            double g = PrimitiveFunction.SQRT.invoke(tmpInvBeta);
            if (vctrWork[m] > 0.0) {
                g = -g;
            }
            tmpInvBeta -= vctrWork[m] * g;
            vctrWork[m] = vctrWork[m] - g;
            for (int j = m; j < size; ++j) {
                int i;
                f = PrimitiveMath.ZERO;
                for (i = sizeM1; i >= m; --i) {
                    f += vctrWork[i] * mtrxH[i + size * j];
                }
                f /= tmpInvBeta;
                for (i = m; i <= sizeM1; ++i) {
                    int n = i + size * j;
                    mtrxH[n] = mtrxH[n] - f * vctrWork[i];
                }
            }
            for (int i = 0; i < size; ++i) {
                int j;
                f = PrimitiveMath.ZERO;
                for (j = sizeM1; j >= m; --j) {
                    f += vctrWork[j] * mtrxH[i + size * j];
                }
                f /= tmpInvBeta;
                for (j = m; j < size; ++j) {
                    int n = i + size * j;
                    mtrxH[n] = mtrxH[n] - f * vctrWork[j];
                }
            }
            vctrWork[m] = tmpColNorm1 * vctrWork[m];
            mtrxH[m + size * ij] = tmpColNorm1 * g;
        }
        for (ij = sizeM2; ij >= 1; --ij) {
            int tmpIndex = ij + size * (ij - 1);
            if (mtrxH[tmpIndex] == PrimitiveMath.ZERO) continue;
            for (int i = ij + 1; i <= sizeM1; ++i) {
                vctrWork[i] = mtrxH[i + size * (ij - 1)];
            }
            for (int j = ij; j <= sizeM1; ++j) {
                int i;
                double g = PrimitiveMath.ZERO;
                for (i = ij; i <= sizeM1; ++i) {
                    g += vctrWork[i] * trnspV[i + size * j];
                }
                g = g / vctrWork[ij] / mtrxH[tmpIndex];
                for (i = ij; i <= sizeM1; ++i) {
                    int n = i + size * j;
                    trnspV[n] = trnspV[n] + g * vctrWork[i];
                }
            }
        }
    }
}

