/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.BaseStream;
import java.util.stream.StreamSupport;
import org.ojalgo.access.ElementView1D;
import org.ojalgo.access.Factory1D;
import org.ojalgo.access.Iterator1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;

public interface Access1D<N extends Number>
extends Structure1D,
Iterable<N> {
    default public <NN extends Number, R extends Mutate1D.Receiver<NN>> Collectable<NN, R> asCollectable1D() {
        return new Collectable<NN, R>(){

            @Override
            public long count() {
                return Access1D.this.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access1D.this);
            }
        };
    }

    default public void axpy(double a, Mutate1D y) {
        Structure1D.loopMatching(this, y, i -> y.add(i, a * this.doubleValue(i)));
    }

    default public double dot(Access1D<?> vector) {
        DoubleAdder retVal = new DoubleAdder();
        Structure1D.loopMatching(this, vector, i -> retVal.add(this.doubleValue(i) * vector.doubleValue(i)));
        return retVal.doubleValue();
    }

    public double doubleValue(long var1);

    default public ElementView1D<N, ?> elements() {
        return new ElementView(this);
    }

    public N get(long var1);

    @Override
    default public Iterator<N> iterator() {
        return new Iterator1D(this);
    }

    default public BaseStream<N, ? extends BaseStream<N, ?>> stream(boolean parallel) {
        return StreamSupport.stream(this.spliterator(), parallel);
    }

    default public void supplyTo(double[] receiver) {
        int limit = Math.min(receiver.length, (int)this.count());
        for (int i = 0; i < limit; ++i) {
            receiver[i] = this.doubleValue(i);
        }
    }

    default public double[] toRawCopy1D() {
        int tmpLength = (int)this.count();
        double[] retVal = new double[tmpLength];
        this.supplyTo(retVal);
        return retVal;
    }

    public static interface Visitable<N extends Number>
    extends Structure1D {
        default public void visitAll(VoidFunction<N> visitor) {
            this.visitRange(0L, this.count(), visitor);
        }

        public void visitOne(long var1, VoidFunction<N> var3);

        default public void visitRange(long first, long limit, VoidFunction<N> visitor) {
            Structure1D.loopRange(first, limit, i -> this.visitOne(i, visitor));
        }
    }

    public static interface Sliceable<N extends Number>
    extends Structure1D {
        public Access1D<N> sliceRange(long var1, long var3);
    }

    public static interface IndexOf
    extends Structure1D {
        default public long indexOfLargest() {
            return this.indexOfLargestInRange(0L, this.count());
        }

        public long indexOfLargestInRange(long var1, long var3);
    }

    public static final class ElementView<N extends Number>
    implements ElementView1D<N, ElementView<N>> {
        private long myCursor = -1L;
        private final long myLastCursor;
        private final Access1D<N> myValues;

        ElementView(Access1D<N> values) {
            this.myValues = values;
            this.myLastCursor = values.count() - 1L;
        }

        @Override
        public double doubleValue() {
            return this.myValues.doubleValue(this.myCursor);
        }

        @Override
        public N getNumber() {
            return this.myValues.get(this.myCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.myLastCursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0L;
        }

        @Override
        public long index() {
            return this.myCursor;
        }

        @Override
        public ElementView<N> next() {
            ++this.myCursor;
            return this;
        }

        @Override
        public ElementView<N> previous() {
            --this.myCursor;
            return this;
        }
    }

    public static interface Elements
    extends Structure1D {
        public boolean isAbsolute(long var1);

        default public boolean isAllSmall(double comparedTo) {
            boolean retVal = true;
            long tmpLimit = this.count();
            for (long i = 0L; retVal && i < tmpLimit; retVal &= this.isSmall(i, comparedTo), ++i) {
            }
            return retVal;
        }

        public boolean isSmall(long var1, double var3);
    }

    public static interface Collectable<N extends Number, R extends Mutate1D.Receiver<N>>
    extends Structure1D {
        default public <I extends R> I collect(Factory1D<I> factory) {
            Mutate1D.Receiver retVal = (Mutate1D.Receiver)factory.makeZero(this.count());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Number>
    extends Structure1D {
        default public N aggregateAll(Aggregator aggregator) {
            return this.aggregateRange(0L, this.count(), aggregator);
        }

        public N aggregateRange(long var1, long var3, Aggregator var5);
    }
}

