/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.imageplus;

import ij.ImagePlus;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class ImagePlusImg<T extends NativeType<T>, A extends ArrayDataAccess<A>>
extends PlanarImg<T, A> {
    protected final int width;
    protected final int height;
    protected final int depth;
    protected final int frames;
    protected final int channels;

    protected ImagePlusImg(ImagePlus imp) {
        this(imp.getWidth(), imp.getHeight(), imp.getNSlices(), imp.getNFrames(), imp.getNChannels(), new Fraction());
    }

    protected ImagePlusImg(int width, int height, int depth, int frames, int channels, Fraction entitiesPerPixel) {
        super(ImagePlusImg.reduceDimensions(new long[]{width, height, channels, depth, frames}), entitiesPerPixel);
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.frames = frames;
        this.channels = channels;
    }

    ImagePlusImg(long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        assert (dim.length < 6) : "ImagePlusContainer can only handle up to 5 dimensions.";
        this.width = dim.length > 0 ? (int)dim[0] : 1;
        this.height = dim.length > 1 ? (int)dim[1] : 1;
        this.channels = dim.length > 2 ? (int)dim[2] : 1;
        this.depth = dim.length > 3 ? (int)dim[3] : 1;
        this.frames = dim.length > 4 ? (int)dim[4] : 1;
    }

    ImagePlusImg(A creator, long[] dim, Fraction entitiesPerPixel) {
        this(dim, entitiesPerPixel);
        this.mirror.clear();
        for (int i = 0; i < this.numSlices; ++i) {
            this.mirror.add(creator.createArray((int)Math.ceil((double)(this.width * this.height) * entitiesPerPixel.getRatio())));
        }
    }

    public ImagePlus getImagePlus() throws ImgLibException {
        throw new ImgLibException((Object)this, "has no ImagePlus instance, it is not a standard type of ImagePlus");
    }

    protected static long[] reduceDimensions(ImagePlus imp) {
        int[] dimensions = imp.getDimensions();
        long[] impDimensions = new long[dimensions.length];
        for (int d = 0; d < dimensions.length; ++d) {
            impDimensions[d] = dimensions[d];
        }
        return ImagePlusImg.reduceDimensions(impDimensions);
    }

    protected static long[] reduceDimensions(long[] impDimensions) {
        int n = 2;
        for (int d = 2; d < impDimensions.length; ++d) {
            if (impDimensions[d] <= 1L) continue;
            ++n;
        }
        long[] dim = new long[n];
        dim[0] = impDimensions[0];
        dim[1] = impDimensions[1];
        n = 1;
        if (impDimensions[2] > 1L) {
            dim[++n] = impDimensions[2];
        }
        if (impDimensions[3] > 1L) {
            dim[++n] = impDimensions[3];
        }
        if (impDimensions[4] > 1L) {
            dim[++n] = impDimensions[4];
        }
        return dim;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFrames() {
        return this.frames;
    }

    public ImagePlusImgFactory<T> factory() {
        return new ImagePlusImgFactory();
    }

    public void close() {
    }

    protected int numEntities(Fraction entities) {
        return (int)Math.ceil((double)(this.width * this.height) * entities.getRatio());
    }
}

