/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.codec.JPEG2000CodecOptions;
import io.scif.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import io.scif.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi;
import io.scif.services.JAIIIOService;
import io.scif.services.ServiceException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class JAIIIOServiceImpl
extends AbstractService
implements JAIIIOService {
    @Override
    public void writeImage(OutputStream out, BufferedImage img, JPEG2000CodecOptions options) throws IOException, ServiceException {
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageWriterSpi> iter = ServiceRegistry.lookupProviders(J2KImageWriterSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageWriterSpi spi = registry.getServiceProviderByClass(J2KImageWriterSpi.class);
        J2KImageWriter writer = new J2KImageWriter((ImageWriterSpi)spi);
        writer.setOutput((Object)ios);
        String filter = options.lossless ? "w5x3" : "w9x7";
        IIOImage iioImage = new IIOImage(img, null, null);
        J2KImageWriteParam param = (J2KImageWriteParam)writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("JPEG2000");
        param.setLossless(options.lossless);
        param.setFilter(filter);
        param.setCodeBlockSize(options.codeBlockSize);
        param.setEncodingRate(options.quality);
        if (options.tileWidth > 0 && options.tileHeight > 0) {
            param.setTiling(options.tileWidth, options.tileHeight, options.tileGridXOffset, options.tileGridYOffset);
        }
        if (options.numDecompositionLevels != null) {
            param.setNumDecompositionLevels(options.numDecompositionLevels.intValue());
        }
        writer.write(null, iioImage, (ImageWriteParam)param);
        ios.close();
    }

    @Override
    @Deprecated
    public void writeImage(OutputStream out, BufferedImage img, boolean lossless, int[] codeBlockSize, double quality) throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = lossless;
        options.codeBlockSize = codeBlockSize;
        options.quality = quality;
        this.writeImage(out, img, options);
    }

    @Override
    public BufferedImage readImage(InputStream in, JPEG2000CodecOptions options) throws IOException, ServiceException {
        J2KImageReader reader = this.getReader();
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        reader.setInput((Object)mciis, false, true);
        J2KImageReadParam param = (J2KImageReadParam)reader.getDefaultReadParam();
        if (options.resolution != null) {
            param.setResolution(options.resolution.intValue());
        }
        return reader.read(0, (ImageReadParam)param);
    }

    @Override
    public BufferedImage readImage(InputStream in) throws IOException, ServiceException {
        return this.readImage(in, JPEG2000CodecOptions.getDefaultOptions());
    }

    @Override
    public Raster readRaster(InputStream in, JPEG2000CodecOptions options) throws IOException, ServiceException {
        J2KImageReader reader = this.getReader();
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        reader.setInput((Object)mciis, false, true);
        J2KImageReadParam param = (J2KImageReadParam)reader.getDefaultReadParam();
        if (options.resolution != null) {
            param.setResolution(options.resolution.intValue());
        }
        return reader.readRaster(0, (ImageReadParam)param);
    }

    @Override
    public Raster readRaster(InputStream in) throws IOException, ServiceException {
        return this.readRaster(in, JPEG2000CodecOptions.getDefaultOptions());
    }

    private J2KImageReader getReader() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageReaderSpi> iter = ServiceRegistry.lookupProviders(J2KImageReaderSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageReaderSpi spi = registry.getServiceProviderByClass(J2KImageReaderSpi.class);
        return new J2KImageReader((ImageReaderSpi)spi);
    }
}

