/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.AxisGuesser;
import io.scif.FilePattern;
import io.scif.NumberFilter;
import io.scif.io.Location;
import io.scif.services.FilePatternService;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ArrayUtils;

@Plugin(type=Service.class)
public class DefaultFilePatternService
extends AbstractService
implements FilePatternService {
    @Override
    public String findPattern(String path) {
        return this.findPattern(new Location(this.getContext(), path));
    }

    @Override
    public String findPattern(Location file) {
        return this.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    @Override
    public String findPattern(File file) {
        return this.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    @Override
    public String findPattern(String name, String dir) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        Location dirFile = new Location(this.getContext(), dir.equals("") ? "." : dir);
        Location[] f = dirFile.listFiles();
        if (f == null) {
            return null;
        }
        String[] nameList = new String[f.length];
        for (int i = 0; i < nameList.length; ++i) {
            nameList[i] = f[i].getName();
        }
        return this.findPattern(name, dir, nameList);
    }

    @Override
    public String findPattern(String name, String dir, String[] nameList) {
        return this.findPattern(name, dir, nameList, null);
    }

    @Override
    public String findPattern(String name, String dir, String[] nameList, int[] excludeAxes) {
        int i;
        if (excludeAxes == null) {
            excludeAxes = new int[]{};
        }
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        int len = name.length();
        int bound = (len + 1) / 2;
        int[] indexList = new int[bound];
        int[] endList = new int[bound];
        int q = 0;
        boolean num = false;
        int ndx = -1;
        int e = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = name.charAt(i2);
            if (c >= '0' && c <= '9') {
                if (num) {
                    ++e;
                    continue;
                }
                num = true;
                ndx = i2;
                e = ndx + 1;
                continue;
            }
            if (!num) continue;
            num = false;
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        if (num) {
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        StringBuilder sb = new StringBuilder(dir);
        for (i = 0; i < q; ++i) {
            int last = i > 0 ? endList[i - 1] : 0;
            String prefix = name.substring(last, indexList[i]);
            int axisType = AxisGuesser.getAxisType(prefix);
            if (ArrayUtils.contains((int[])excludeAxes, (int)axisType)) {
                sb.append(name.substring(last, endList[i]));
                continue;
            }
            sb.append(prefix);
            String pre = name.substring(0, indexList[i]);
            String post = name.substring(endList[i]);
            NumberFilter filter = new NumberFilter(pre, post);
            String[] list = this.matchFiles(nameList, filter);
            if (list == null || list.length == 0) {
                return null;
            }
            if (list.length == 1) {
                sb.append(name.substring(indexList[i], endList[i]));
                continue;
            }
            boolean fix = true;
            for (String s : list) {
                if (s.length() == len) continue;
                fix = false;
                break;
            }
            if (fix) {
                int j;
                int width = endList[i] - indexList[i];
                boolean[] same = new boolean[width];
                block3: for (j = 0; j < width; ++j) {
                    same[j] = true;
                    int jx = indexList[i] + j;
                    char c = name.charAt(jx);
                    for (String s : list) {
                        if (s.charAt(jx) == c) continue;
                        same[j] = false;
                        continue block3;
                    }
                }
                j = 0;
                while (j < width) {
                    int c;
                    int jx = indexList[i] + j;
                    if (same[j]) {
                        sb.append(name.charAt(jx));
                        ++j;
                        continue;
                    }
                    while (j < width && !same[j]) {
                        ++j;
                    }
                    String p = this.findPattern(name, nameList, jx, indexList[i] + j, "");
                    int n = c = indexList[i] > 0 ? (int)name.charAt(indexList[i] - 1) : 46;
                    if (p == null && c != 83 && c != 115 && c != 69 && c != 101) {
                        return null;
                    }
                    if (p == null) {
                        sb.append(name.charAt(endList[i] - 1));
                        continue;
                    }
                    sb.append(p);
                }
                continue;
            }
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = filter.getNumber(list[j]);
            }
            Arrays.sort(numbers);
            String bounds = this.getBounds((BigInteger[])numbers, false);
            if (bounds == null) {
                return null;
            }
            sb.append(bounds);
        }
        sb.append(q > 0 ? name.substring(endList[q - 1]) : name);
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String findPattern(String[] names) {
        String dir = names[0].substring(0, names[0].lastIndexOf(File.separator) + 1);
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote(dir));
        for (int i = 0; i < names.length; ++i) {
            pattern.append("(?:");
            String name = names[i].substring(names[i].lastIndexOf(File.separator) + 1);
            pattern.append(Pattern.quote(name));
            pattern.append(")");
            if (i >= names.length - 1) continue;
            pattern.append("|");
        }
        return pattern.toString();
    }

    @Override
    public String[] findImagePatterns(String base) {
        Location file = new Location(this.getContext(), base).getAbsoluteFile();
        Location parent = file.getParentFile();
        String[] list = parent.list(true);
        return this.findImagePatterns(base, parent.getAbsolutePath(), list);
    }

    @Override
    public String[] findImagePatterns(String base, String dir, String[] nameList) {
        String baseSuffix = base.substring(base.lastIndexOf(File.separator) + 1);
        int dot = baseSuffix.indexOf(".");
        baseSuffix = dot < 0 ? "" : baseSuffix.substring(dot + 1);
        ArrayList<String> patterns = new ArrayList<String>();
        int[] exclude = new int[]{4};
        for (String name : nameList) {
            String patternSuffix;
            String pattern = this.findPattern(name, dir, nameList, exclude);
            if (pattern == null) continue;
            int start = pattern.lastIndexOf(File.separator) + 1;
            if (start < 0) {
                start = 0;
            }
            patternSuffix = (dot = (patternSuffix = pattern.substring(start)).indexOf(".")) < 0 ? "" : patternSuffix.substring(dot + 1);
            String checkPattern = this.findPattern(name, dir, nameList);
            Object[] checkFiles = new FilePattern(this.getContext(), checkPattern).getFiles();
            if (patterns.contains(pattern) || new Location(this.getContext(), pattern).exists() && !base.equals(pattern) || !patternSuffix.equals(baseSuffix) || ArrayUtils.indexOf((Object[])checkFiles, (Object)base) < 0) continue;
            patterns.add(pattern);
        }
        Object[] s = patterns.toArray(new String[patterns.size()]);
        Arrays.sort(s);
        return s;
    }

    private String findPattern(String name, String[] nameList, int ndx, int end, String p) {
        if (ndx == end) {
            return p;
        }
        for (int i = end - ndx; i >= 1; --i) {
            String pat;
            NumberFilter filter = new NumberFilter(name.substring(0, ndx), name.substring(ndx + i));
            String[] list = this.matchFiles(nameList, filter);
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = new BigInteger(list[j].substring(ndx, ndx + i));
            }
            Arrays.sort(numbers);
            String bounds = this.getBounds((BigInteger[])numbers, true);
            if (bounds == null || (pat = this.findPattern(name, nameList, ndx + i, end, p + bounds)) == null) continue;
            return pat;
        }
        return null;
    }

    private String getBounds(BigInteger[] numbers, boolean fixed) {
        if (numbers.length < 2) {
            return null;
        }
        BigInteger b = numbers[0];
        BigInteger e = numbers[numbers.length - 1];
        BigInteger s = numbers[1].subtract(b);
        if (s.equals(BigInteger.ZERO)) {
            return null;
        }
        for (int i = 2; i < numbers.length; ++i) {
            if (numbers[i].subtract(numbers[i - 1]).equals(s)) continue;
            return null;
        }
        String sb = b.toString();
        String se = e.toString();
        StringBuilder bounds = new StringBuilder("<");
        if (fixed) {
            int zeroes = se.length() - sb.length();
            for (int i = 0; i < zeroes; ++i) {
                bounds.append("0");
            }
        }
        bounds.append(sb);
        bounds.append("-");
        bounds.append(se);
        if (!s.equals(BigInteger.ONE)) {
            bounds.append(":");
            bounds.append(s);
        }
        bounds.append(">");
        return bounds.toString();
    }

    private String[] matchFiles(String[] inFiles, NumberFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String inFile : inFiles) {
            if (!filter.accept(inFile)) continue;
            list.add(inFile);
        }
        return list.toArray(new String[0]);
    }
}

