/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.ByteArrayHandle;
import io.scif.io.FileHandle;
import io.scif.io.IRandomAccess;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channel;

public class NIOInputStream
extends InputStream
implements DataInput {
    private static final int DEFAULT_BLOCK_SIZE = 262144;
    private static final int MAX_SEARCH_SIZE = 0x20000000;
    private final IRandomAccess raf;
    private String filename;
    private File file;
    private Channel channel;
    private boolean isLittleEndian;

    public NIOInputStream(String filename) throws IOException {
        this.filename = filename;
        this.file = new File(filename);
        this.raf = new FileHandle(this.file, "r");
    }

    public NIOInputStream(IRandomAccess handle) {
        this.raf = handle;
    }

    public NIOInputStream(byte[] array) {
        this(new ByteArrayHandle(array));
    }

    public DataInputStream getInputStream() {
        return null;
    }

    public void setExtend(int extend) {
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public int read() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public long getFilePointer() {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public void order(boolean isLittleEndian) {
        this.isLittleEndian = isLittleEndian;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public String readString(String lastChars) throws IOException {
        if (lastChars.length() == 1) {
            return this.findString(lastChars);
        }
        String[] terminators = new String[lastChars.length()];
        for (int i = 0; i < terminators.length; ++i) {
            terminators[i] = lastChars.substring(i, i + 1);
        }
        return this.findString(terminators);
    }

    public String findString(String ... terminators) throws IOException {
        return this.findString(true, 262144, terminators);
    }

    public String findString(boolean saveString, String ... terminators) throws IOException {
        return this.findString(saveString, 262144, terminators);
    }

    public String findString(int blockSize, String ... terminators) throws IOException {
        return this.findString(true, blockSize, terminators);
    }

    public String findString(boolean saveString, int blockSize, String ... terminators) throws IOException {
        int r;
        boolean tooLong;
        StringBuilder out = new StringBuilder();
        long startPos = this.getFilePointer();
        long bytesDropped = 0L;
        long inputLen = this.length();
        long maxLen = inputLen - startPos;
        boolean bl = tooLong = saveString && maxLen > 0x20000000L;
        if (tooLong) {
            maxLen = 0x20000000L;
        }
        boolean match = false;
        int maxTermLen = 0;
        for (String term : terminators) {
            int len = term.length();
            if (len <= maxTermLen) continue;
            maxTermLen = len;
        }
        InputStreamReader in = new InputStreamReader((InputStream)this, "UTF-8");
        char[] buf = new char[blockSize];
        for (long loc = 0L; loc < maxLen; loc += (long)r) {
            int outLen;
            long pos = startPos + loc;
            if (!saveString && (outLen = out.length()) >= maxTermLen) {
                int dropIndex = outLen - maxTermLen + 1;
                String last = out.substring(dropIndex, outLen);
                out.setLength(0);
                out.append(last);
                bytesDropped += (long)dropIndex;
            }
            int num = blockSize;
            if (pos + (long)blockSize > inputLen) {
                num = (int)(inputLen - pos);
            }
            if ((r = in.read(buf, 0, num)) <= 0) {
                throw new IOException("Cannot read from stream: " + r);
            }
            out.append(buf, 0, r);
            int min = Integer.MAX_VALUE;
            int tagLen = 0;
            String[] stringArray = terminators;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String terminator;
                int len = (terminator = stringArray[i]).length();
                int start = (int)(loc - bytesDropped - (long)len);
                int value = out.indexOf(terminator, start < 0 ? 0 : start);
                if (value < 0 || value >= min) continue;
                match = true;
                min = value;
                tagLen = len;
            }
            if (!match) continue;
            this.seek(startPos + bytesDropped + (long)min + (long)tagLen);
            if (saveString) {
                out.setLength(min + tagLen);
                return out.toString();
            }
            return null;
        }
        if (tooLong) {
            throw new IOException("Maximum search length reached.");
        }
        return null;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.findString("\n");
    }

    public String readCString() throws IOException {
        return this.findString("\u0000");
    }

    public String readString(int n) throws IOException {
        byte[] b = new byte[n];
        this.readFully(b);
        return new String(b, "UTF-8");
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return null;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    @Override
    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    @Override
    public int read(byte[] array, int offset, int n) throws IOException {
        return this.raf.read(array, offset, n);
    }

    @Override
    public void readFully(byte[] array) throws IOException {
        this.readFully(array, 0, array.length);
    }

    @Override
    public void readFully(byte[] array, int offset, int n) throws IOException {
        this.raf.readFully(array, offset, n);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        this.raf.seek(0L);
    }
}

