/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.GenericByteType;

public class ByteArrayLoader
extends AbstractArrayLoader<ByteArray> {
    public ByteArrayLoader(Reader reader, ImageRegion subRegion) {
        super(reader, subRegion);
    }

    @Override
    public void convertBytes(ByteArray data, byte[] bytes, int planesRead) {
        if (this.isCompatible()) {
            int offset = planesRead * bytes.length;
            System.arraycopy(bytes, 0, data.getCurrentStorageArray(), offset, bytes.length);
        } else {
            ImageMetadata iMeta = this.reader().getMetadata().get(0);
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                byte value = (byte)this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public ByteArray emptyArray(int entities) {
        return new ByteArray(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 8;
    }

    @Override
    public Class<?> outputClass() {
        return GenericByteType.class;
    }
}

