/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.FormatException;
import io.scif.Reader;
import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.refs.RefManagerService;
import java.io.IOException;
import net.imglib2.display.ColorTable;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.LazyCellImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;
import org.scijava.Disposable;

public class SCIFIOCellImg<T extends NativeType<T>, A extends ArrayDataAccess<A>>
extends AbstractCellImg<T, A, SCIFIOCell<A>, LazyCellImg.LazyCells<SCIFIOCell<A>>>
implements Disposable {
    private final Reader reader;
    private SCIFIOArrayLoader<?> loader;
    private final SCIFIOCellImgFactory<T> factory;

    public SCIFIOCellImg(SCIFIOCellImgFactory<T> factory, CellGrid grid, LazyCellImg.LazyCells<SCIFIOCell<A>> cells, Fraction entitiesPerPixel) {
        super(grid, cells, entitiesPerPixel);
        this.factory = factory;
        this.reader = factory.reader();
        ((RefManagerService)this.reader.getContext().getService(RefManagerService.class)).manage((Object)this, new Object[0]);
    }

    public ColorTable getColorTable(int imageIndex, int planeIndex) throws FormatException, IOException {
        if (this.loader != null) {
            return this.loader.loadTable(imageIndex, planeIndex);
        }
        long[] planeMin = new long[this.reader.getMetadata().get(imageIndex).getAxesPlanar().size()];
        long[] planeMax = new long[planeMin.length];
        for (int i = 0; i < planeMax.length; ++i) {
            planeMax[i] = 1L;
        }
        return this.reader.openPlane(imageIndex, (long)planeIndex, planeMin, planeMax).getColorTable();
    }

    public SCIFIOCellImgFactory<T> factory() {
        return this.factory;
    }

    public Reader reader() {
        return this.reader;
    }

    public void setLoader(SCIFIOArrayLoader<?> loader) {
        this.loader = loader;
    }

    public SCIFIOCellImg<T, A> copy() {
        SCIFIOCellImg<NativeType, ?> copy = this.factory().create(this.dimension, (NativeType)((NativeType)this.firstElement()).createVariable());
        super.copyDataTo(copy);
        return copy;
    }

    public void dispose() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

