/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.cache.CacheResult;
import io.scif.img.cell.cache.CacheService;
import io.scif.refs.CleaningRef;
import io.scif.refs.RefProvider;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=RefProvider.class)
public class SCIFIOCellCleaningProvider
extends AbstractSCIFIOPlugin
implements RefProvider {
    @Override
    public boolean handles(Object referent, Object ... params) {
        boolean handles = SCIFIOCell.class.isAssignableFrom(referent.getClass());
        handles = handles && (params == null || params.length == 0);
        return handles;
    }

    @Override
    public Reference makeRef(Object referent, ReferenceQueue queue, Object ... params) {
        SCIFIOCellCleaner ref = new SCIFIOCellCleaner(referent, queue);
        this.getContext().inject(ref);
        return ref;
    }

    public static class SCIFIOCellCleaner<A extends ArrayDataAccess<A>>
    extends PhantomReference<SCIFIOCell<A>>
    implements CleaningRef {
        @Parameter
        private LogService logService;
        @Parameter
        private CacheService<SCIFIOCell<?>> service;
        private A data;
        private final int[] hashes;
        private final long[] elementSize;
        private final boolean[] enabled;
        private final long[] min;
        private final int[] dims;
        private final String cacheId;
        private final int index;

        public SCIFIOCellCleaner(Object referent, ReferenceQueue queue) {
            super((SCIFIOCell)((Object)referent), queue);
            SCIFIOCell cell = (SCIFIOCell)((Object)referent);
            this.data = (ArrayDataAccess)cell.getData();
            this.hashes = cell.getHashes();
            this.elementSize = cell.getESizeArray();
            this.cacheId = cell.getCacheId();
            this.index = cell.getIndex();
            this.enabled = cell.isEnabled();
            this.dims = new int[cell.dimCount()];
            cell.dimensions(this.dims);
            this.min = new long[cell.dimCount()];
            cell.min(this.min);
        }

        @Override
        public void cleanup() {
            SCIFIOCell<A> cell = new SCIFIOCell<A>(this.data, this.hashes[1], this.hashes[0], this.elementSize[0], this.dims, this.min);
            cell.cacheOnFinalize(this.enabled[0]);
            CacheResult result = this.service.cache(this.cacheId, this.index, cell);
            cell = null;
            this.data = null;
            this.clear();
        }
    }
}

