/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.Reader;
import io.scif.Writer;
import io.scif.config.SCIFIOConfig;
import io.scif.img.AbstractImgIOComponent;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import io.scif.img.ImgSaver;
import io.scif.img.SCIFIOImgPlus;
import io.scif.refs.RefManagerService;
import java.util.List;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.Context;
import org.scijava.log.LogService;

public final class IO {
    private static LogService logService;

    public static List<SCIFIOImgPlus<?>> openImgs(String source) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<FloatType>> openFloatImgs(String source) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<FloatType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new FloatType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<DoubleType>> openDoubleImgs(String source) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<DoubleType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new DoubleType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<UnsignedByteType>> openUnsignedByteImgs(String source) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<UnsignedByteType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new UnsignedByteType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, type);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<?>> openImgs(String source, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, type, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<?>> openImgs(String source, ImgFactory imgFactory) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, imgFactory);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static List<SCIFIOImgPlus<?>> openImgs(String source, ImgFactory imgFactory, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, imgFactory, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory, T type) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, imgFactory, type);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, type, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, type, imgFactory, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static void saveImg(String dest, Img<?> img) {
        try {
            new ImgSaver().saveImg(dest, img);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
    }

    public static void saveImg(String dest, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        try {
            new ImgSaver().saveImg(dest, imgPlus, imageIndex);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
    }

    public static void saveImg(Writer writer, Img<?> img) {
        try {
            new ImgSaver().saveImg(writer, img);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
    }

    public static void saveImg(Writer writer, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        try {
            new ImgSaver().saveImg(writer, imgPlus, imageIndex);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDatasetName(), (Exception)((Object)e));
        }
    }

    private static void register(List<? extends SCIFIOImgPlus> imgPlus, AbstractImgIOComponent component) {
        Context ctx = component.getContext();
        RefManagerService refManagerService = (RefManagerService)ctx.getService(RefManagerService.class);
        for (SCIFIOImgPlus sCIFIOImgPlus : imgPlus) {
            refManagerService.manage((Object)sCIFIOImgPlus, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ImgOpener opener() {
        ImgOpener opener = new ImgOpener();
        if (logService != null) return opener;
        Class<IO> clazz = IO.class;
        synchronized (IO.class) {
            if (logService != null) return opener;
            logService = (LogService)opener.getContext().getService(LogService.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return opener;
        }
    }

    private static void openError(String source, Exception e) {
        logService.error((Object)("Failed to open ImgPlus for source: " + source), (Throwable)e);
    }

    private static void saveError(String dest, Exception e) {
        logService.error((Object)("Failed to save ImgPlus to id: " + dest), (Throwable)e);
    }

    @Deprecated
    public static SCIFIOImgPlus<?> open(String source) {
        return IO.openImgs(source).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<FloatType> openFloat(String source) {
        return IO.openFloatImgs(source).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<DoubleType> openDouble(String source) {
        return IO.openDoubleImgs(source).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<UnsignedByteType> openUnsignedByte(String source) {
        return IO.openUnsignedByteImgs(source).get(0);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type) {
        return IO.openImgs(source, type).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<?> openImg(String source, SCIFIOConfig config) {
        return IO.openImgs(source, config).get(0);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type, SCIFIOConfig config) {
        return IO.openImgs(source, type, config).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<?> openImg(String source, ImgFactory imgFactory) {
        return IO.openImgs(source, imgFactory).get(0);
    }

    @Deprecated
    public static SCIFIOImgPlus<?> openImg(String source, ImgFactory imgFactory, SCIFIOConfig config) {
        return IO.openImgs(source, imgFactory, config).get(0);
    }

    @Deprecated
    public static <T extends RealType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory, T type) {
        return IO.openImgs(source, imgFactory, type).get(0);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, SCIFIOConfig config) {
        return IO.openImgs(reader, type, config).get(0);
    }

    @Deprecated
    public static <T extends RealType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.openImgs(reader, type, imgFactory, config).get(0);
    }
}

