/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractWriter;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.DefaultImageMetadata;
import io.scif.DefaultTranslator;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.IFDList;
import io.scif.formats.tiff.TiffParser;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Encapsulated PostScript")
public class EPSFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"eps", "epsi", "ps"};
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class EPSTranslator
    extends DefaultTranslator {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        private static final String DUMMY_PIXEL = "00";
        private long planeOffset = 0L;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws IOException, FormatException {
            if (!this.isInitialized(imageIndex, (int)planeIndex)) {
                this.writeHeader(imageIndex);
                if (!SCIFIOMetadataTools.wholePlane(imageIndex, this.getMetadata(), planeMin, planeMax)) {
                    int xAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.X);
                    int yAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.Y);
                    int w = (int)planeMax[xAxis];
                    int h = (int)planeMax[yAxis];
                    int nChannels = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
                    int planeSize = w * h * nChannels;
                    for (int i = 0; i < planeSize; ++i) {
                        this.getStream().writeBytes(DUMMY_PIXEL);
                    }
                }
            }
            super.initialize(imageIndex, planeIndex, planeMin, planeMax);
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            byte[] buf = plane.getBytes();
            boolean interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            this.checkParams(imageIndex, planeIndex, buf, planeMin, planeMax);
            int xAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            int sizeX = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.X);
            int nChannels = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
            int planeSize = (int)(planeMax[xAxis] * planeMax[yAxis]);
            StringBuilder buffer = new StringBuilder();
            int offset = y * sizeX * nChannels * 2;
            this.getStream().seek(this.planeOffset + (long)offset);
            for (int row = 0; row < h; ++row) {
                this.getStream().skipBytes(nChannels * x * 2);
                for (int col = 0; col < w * nChannels; ++col) {
                    int i = row * w * nChannels + col;
                    int index = interleaved || nChannels == 1 ? i : i % nChannels * planeSize + i / nChannels;
                    String s = Integer.toHexString(buf[index]);
                    if (s.length() > 1) {
                        buffer.append(s.substring(s.length() - 2));
                        continue;
                    }
                    buffer.append("0");
                    buffer.append(s);
                }
                this.getStream().writeBytes(buffer.toString());
                buffer.delete(0, buffer.length());
                this.getStream().skipBytes(nChannels * (sizeX - w - x) * 2);
            }
            this.getStream().seek(this.getStream().length());
            this.getStream().writeBytes("\nshowpage\n");
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{1};
        }

        private void writeHeader(int imageIndex) throws IOException {
            int width = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.X);
            int height = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
            int nChannels = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
            this.getStream().writeBytes("%!PS-Adobe-2.0 EPSF-1.2\n");
            this.getStream().writeBytes("%%Title: " + ((Metadata)this.getMetadata()).getDatasetName() + "\n");
            this.getStream().writeBytes("%%Creator: SCIFIO\n");
            this.getStream().writeBytes("%%Pages: 1\n");
            this.getStream().writeBytes("%%BoundingBox: 0 0 " + width + " " + height + "\n");
            this.getStream().writeBytes("%%EndComments\n\n");
            this.getStream().writeBytes("/ld {load def} bind def\n");
            this.getStream().writeBytes("/s /stroke ld /f /fill ld /m /moveto ld /l /lineto ld /c /curveto ld /rgb {255 div 3 1 roll 255 div 3 1 roll 255 div 3 1 roll setrgbcolor} def\n");
            this.getStream().writeBytes("0 0 translate\n");
            this.getStream().writeBytes((float)width + " " + (float)height + " scale\n");
            this.getStream().writeBytes("/picstr 40 string def\n");
            this.getStream().writeBytes(width + " " + height + " 8 [" + width + " 0 0 " + -1 * height + " 0 " + height + "] {currentfile picstr readhexstring pop} ");
            if (nChannels == 1) {
                this.getStream().writeBytes("image\n");
            } else {
                this.getStream().writeBytes("false 3 colorimage\n");
            }
            this.planeOffset = this.getStream().getFilePointer();
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            Metadata meta = (Metadata)this.getMetadata();
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            if (meta.isTiff()) {
                long[] offsets = ((IFD)meta.getIfds().get(0)).getStripOffsets();
                this.getStream().seek(offsets[0]);
                int[] map = ((IFD)meta.getIfds().get(0)).getIFDIntArray(320);
                if (map == null) {
                    this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
                    return plane;
                }
                byte[] b = new byte[w * h];
                this.getStream().skipBytes(2 * y * (int)meta.get(imageIndex).getAxisLength(Axes.X));
                for (int row = 0; row < h; ++row) {
                    this.getStream().skipBytes(x * 2);
                    for (int col = 0; col < w; ++col) {
                        b[row * w + col] = (byte)(this.getStream().readShort() & 0xFF);
                    }
                    this.getStream().skipBytes(2 * (int)(meta.get(imageIndex).getAxisLength(Axes.X) - (long)w - (long)x));
                }
                for (int i = 0; i < b.length; ++i) {
                    int ndx = b[i] & 0xFF;
                    for (int j = 0; j < (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL); ++j) {
                        if (j < 3) {
                            buf[i * (int)meta.get((int)imageIndex).getAxisLength((AxisType)Axes.CHANNEL) + j] = (byte)map[ndx + j * 256];
                            continue;
                        }
                        boolean zero = map[ndx] == 0 && map[ndx + 256] == 0 && map[ndx + 512] == 0;
                        buf[i * (int)meta.get((int)imageIndex).getAxisLength((AxisType)Axes.CHANNEL) + j] = zero ? 0 : -1;
                    }
                }
                return plane;
            }
            if (meta.getStart() == 0) {
                throw new FormatException("Vector data not supported.");
            }
            this.getStream().seek(0L);
            for (int line = 0; line <= meta.getStart(); ++line) {
                this.getStream().readLine();
            }
            int bytes = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
            if (meta.isBinary()) {
                this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
            } else {
                String pix = this.getStream().readString((int)(this.getStream().length() - this.getStream().getFilePointer()));
                pix = pix.replaceAll("\n", "");
                pix = pix.replaceAll("\r", "");
                int ndx = (int)(meta.get(imageIndex).getAxisLength(Axes.CHANNEL) * (long)y * (long)bytes * meta.get(imageIndex).getAxisLength(Axes.X));
                int destNdx = 0;
                for (int row = 0; row < h; ++row) {
                    ndx = (int)((long)ndx + (long)x * meta.get(imageIndex).getAxisLength(Axes.CHANNEL) * (long)bytes);
                    int col = 0;
                    while ((long)col < (long)w * meta.get(imageIndex).getAxisLength(Axes.CHANNEL) * (long)bytes) {
                        buf[destNdx++] = (byte)Integer.parseInt(pix.substring(2 * ndx, 2 * (ndx + 1)), 16);
                        ++ndx;
                        ++col;
                    }
                    ndx = (int)((long)ndx + meta.get(imageIndex).getAxisLength(Axes.CHANNEL) * (long)bytes * (meta.get(imageIndex).getAxisLength(Axes.X) - (long)w - (long)x));
                }
            }
            return plane;
        }

        @Override
        public long getOptimalTileWidth(int imageIndex) {
            try {
                if (((Metadata)this.getMetadata()).isTiff) {
                    return (int)((IFD)((Metadata)this.getMetadata()).getIfds().get(0)).getTileWidth();
                }
            }
            catch (FormatException e) {
                this.log().debug((Object)"Could not retrieve tile width", (Throwable)e);
            }
            return super.getOptimalTileWidth(imageIndex);
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            try {
                if (((Metadata)this.getMetadata()).isTiff()) {
                    return (int)((IFD)((Metadata)this.getMetadata()).getIfds().get(0)).getTileLength();
                }
            }
            catch (FormatException e) {
                this.log().debug((Object)"Could not retrieve tile height", (Throwable)e);
            }
            return super.getOptimalTileHeight(imageIndex);
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.createImageMetadata(1);
            ImageMetadata m = meta.get(0);
            MetaTable globalTable = meta.getTable();
            this.log().info((Object)"Verifying EPS format");
            String line = this.getSource().readLine();
            if (!line.trim().startsWith("%!PS")) {
                meta.setTiff(true);
                this.getSource().order(true);
                this.getSource().seek(20L);
                int offset = this.getSource().readInt();
                int len = this.getSource().readInt();
                byte[] b = new byte[len];
                this.getSource().seek(offset);
                this.getSource().read(b);
                RandomAccessInputStream ifdSource = new RandomAccessInputStream(this.getContext(), b);
                TiffParser tp = new TiffParser(this.getContext(), ifdSource);
                ifdSource.close();
                meta.setIfds(tp.getIFDs());
                IFD firstIFD = (IFD)meta.getIfds().get(0);
                m.setAxisLength(Axes.CHANNEL, (long)firstIFD.getSamplesPerPixel());
                m.setAxisLength(Axes.X, (long)((int)firstIFD.getImageWidth()));
                m.setAxisLength(Axes.Y, (long)((int)firstIFD.getImageLength()));
                if (m.getAxisLength(Axes.CHANNEL) == 2L) {
                    m.setAxisLength(Axes.CHANNEL, 4L);
                }
                m.setLittleEndian(firstIFD.isLittleEndian());
                m.setPixelType(firstIFD.getPixelType());
                m.setMetadataComplete(true);
                m.setIndexed(false);
                m.setFalseColor(false);
                return;
            }
            this.log().info((Object)"Finding image data");
            meta.setBinary(false);
            String image = "image";
            int lineNum = 1;
            line = this.getSource().readLine().trim();
            m.setAxes(FormatTools.createAxes(Axes.X, Axes.Y, Axes.CHANNEL));
            while (line != null && !line.equals("%%EOF")) {
                block15: {
                    block13: {
                        block14: {
                            if (line.endsWith(image)) {
                                if (!line.startsWith(image)) {
                                    if (line.contains("colorimage")) {
                                        m.setAxisLength(Axes.CHANNEL, 3L);
                                    }
                                    String[] t = line.split(" ");
                                    try {
                                        m.setAxisLength(Axes.X, (long)Integer.parseInt(t[0]));
                                        m.setAxisLength(Axes.Y, (long)Integer.parseInt(t[1]));
                                    }
                                    catch (NumberFormatException exc) {
                                        this.log().debug((Object)"Could not parse image dimensions", (Throwable)exc);
                                        m.setAxisLength(Axes.CHANNEL, (long)Integer.parseInt(t[3]));
                                    }
                                }
                                meta.setStart(lineNum);
                                break;
                            }
                            if (!line.startsWith("%%")) break block13;
                            if (line.startsWith("%%BoundingBox:")) {
                                line = line.substring(14).trim();
                                String[] t = line.split(" ");
                                try {
                                    int originX = Integer.parseInt(t[0].trim());
                                    int originY = Integer.parseInt(t[1].trim());
                                    m.setAxisLength(Axes.X, (long)(Integer.parseInt(t[2].trim()) - originY));
                                    m.setAxisLength(Axes.Y, (long)(Integer.parseInt(t[3].trim()) - originY));
                                    globalTable.put("X-coordinate of origin", originX);
                                    globalTable.put("Y-coordinate of origin", originY);
                                }
                                catch (NumberFormatException e) {
                                    throw new FormatException("Files without image data are not supported.");
                                }
                            }
                            if (!line.startsWith("%%BeginBinary")) break block14;
                            meta.setBinary(true);
                            break block15;
                        }
                        int ndx = line.indexOf(":");
                        if (ndx == -1) break block15;
                        String key = line.substring(0, ndx);
                        String value = line.substring(ndx + 1);
                        globalTable.put(key, value);
                        break block15;
                    }
                    if (line.startsWith("%ImageData:")) {
                        line = line.substring(11);
                        String[] t = line.split(" ");
                        m.setAxisLength(Axes.X, (long)Integer.parseInt(t[0]));
                        m.setAxisLength(Axes.Y, (long)Integer.parseInt(t[1]));
                        m.setAxisLength(Axes.CHANNEL, (long)Integer.parseInt(t[3]));
                        for (int i = 4; i < t.length; ++i) {
                            image = t[i].trim();
                            if (image.length() <= 1) continue;
                            image = image.substring(1, image.length() - 1);
                        }
                    }
                }
                ++lineNum;
                line = this.getSource().readLine().trim();
            }
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private int start;
        private boolean binary;
        private boolean isTiff;
        private IFDList ifds;

        public Metadata() {
            this.add(new DefaultImageMetadata());
            this.get(0).setLittleEndian(true);
        }

        public IFDList getIfds() {
            return this.ifds;
        }

        public void setIfds(IFDList ifds) {
            this.ifds = ifds;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public void setBinary(boolean binary) {
            this.binary = binary;
        }

        public boolean isTiff() {
            return this.isTiff;
        }

        public void setTiff(boolean isTiff) {
            this.isTiff = isTiff;
        }

        @Override
        public void populateImageMetadata() {
            if (this.get(0).getAxisLength(Axes.CHANNEL) == 0L) {
                this.get(0).setAxisLength(Axes.CHANNEL, 1L);
            }
            if (this.get(0).getPixelType() == 0) {
                this.get(0).setPixelType(1);
            }
            if (this.get(0).getAxisLength(Axes.CHANNEL) != 3L) {
                this.get(0).setPlanarAxisCount(2);
                this.get(0).setAxisTypes(Axes.X, Axes.Y, Axes.CHANNEL);
            } else {
                this.get(0).setPlanarAxisCount(3);
                this.get(0).setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.isTiff = false;
                this.ifds = null;
                this.start = 0;
                this.binary = false;
            }
        }
    }
}

