/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.widget;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.imagej.widget.ColorTableWidget;
import net.imglib2.display.ColorTable;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingColorTableWidget
extends SwingInputWidget<ColorTable>
implements ColorTableWidget<JPanel> {
    private BufferedImage image = new BufferedImage(256, 20, 1);
    private JLabel picLabel;

    public ColorTable getValue() {
        return (ColorTable)this.get().getValue();
    }

    public void set(WidgetModel model) {
        super.set(model);
        this.picLabel = new JLabel();
        this.getComponent().add(this.picLabel);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return model.isType(ColorTable.class);
    }

    public void doRefresh() {
        ColorTable colorTable = this.getValue();
        this.fillImage(colorTable);
        this.picLabel.setIcon(new ImageIcon(this.image));
        this.picLabel.repaint();
    }

    private void fillImage(ColorTable cTable) {
        for (int x = 0; x < 256; ++x) {
            int r = cTable.get(0, x) & 0xFF;
            int g = cTable.get(1, x) & 0xFF;
            int b = cTable.get(2, x) & 0xFF;
            int rgb = r << 16 | g << 8 | b;
            for (int y = 0; y < 20; ++y) {
                this.image.setRGB(x, y, rgb);
            }
        }
    }
}

