/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.mimetype;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class MIMEContainer {
    private MIME mime;
    private String code;

    public MIMEContainer() {
    }

    public MIMEContainer(MIME mime) {
        this.mime = mime;
    }

    public MIMEContainer(MIME mime, String code) {
        this.mime = mime;
        this.code = code;
    }

    public MIME getMime() {
        return this.mime;
    }

    public String getCode() {
        return this.code;
    }

    public static MIMEContainer HIDDEN() {
        return MIMEContainer.addMimeType(MIME.HIDDEN);
    }

    public static MIMEContainer HTML(Object code) {
        return MIMEContainer.addMimeType(MIME.TEXT_HTML, code);
    }

    public static MIMEContainer Latex(Object code) {
        return MIMEContainer.addMimeType(MIME.TEXT_LATEX, code);
    }

    public static MIMEContainer Text(Object code) {
        return MIMEContainer.addMimeType(MIME.TEXT_PLAIN, code);
    }

    public static MIMEContainer Markdown(Object code) {
        return MIMEContainer.addMimeType(MIME.TEXT_MARKDOWN, code);
    }

    public static MIMEContainer Math(String code) {
        code = StringUtils.strip((String)code, (String)"$");
        return MIMEContainer.addMimeType(MIME.TEXT_LATEX, "$$" + code + "$$");
    }

    public static MIMEContainer Javascript(Object code) {
        return MIMEContainer.addMimeType(MIME.APPLICATION_JAVASCRIPT, code);
    }

    public static MIMEContainer IFrame(String src, Object width, int height) {
        String code = String.format("<iframe width = '%1$s' height= '%2$d' src = '%3$s' frameborder='0' allowfullscreen> </iframe>", width.toString(), height, src);
        return MIMEContainer.addMimeType(MIME.TEXT_HTML, code);
    }

    public static MIMEContainer VimeoVideo(String id, Object width, int height) {
        String src = String.format("https://player.vimeo.com/video/%1$s", id);
        return MIMEContainer.IFrame(src, width, height);
    }

    public static MIMEContainer ScribdDocument(String id, Object width, int height) {
        String src = String.format("https://www.scribd.com/embeds/%1$s/content", id);
        return MIMEContainer.IFrame(src, width, height);
    }

    public static MIMEContainer YoutubeVideo(String id) {
        String src = String.format("https://www.youtube.com/embed/%1$s", id);
        return MIMEContainer.IFrame(src, 400, 300);
    }

    public static MIMEContainer Video(String src) {
        String output = String.format("<video src='%1$s' controls> Your browser does not support the <code>video</code> element. </video>", src);
        return MIMEContainer.addMimeType(MIME.TEXT_HTML, output);
    }

    protected static MIMEContainer addMimeType(MIME mime) {
        return new MIMEContainer(mime);
    }

    protected static MIMEContainer addMimeType(MIME mime, Object code) {
        return new MIMEContainer(mime, code.toString());
    }

    protected static String exceptionToString(Exception e) {
        StringWriter w = new StringWriter();
        PrintWriter printWriter = new PrintWriter(w);
        e.printStackTrace(printWriter);
        printWriter.flush();
        return w.toString();
    }

    protected static boolean exists(String data) {
        File f = new File(data);
        return f.exists() && !f.isDirectory();
    }

    protected static boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static byte[] getBytes(Object data) throws IOException {
        byte[] bytes;
        if (MIMEContainer.isValidURL(data.toString())) {
            bytes = ByteStreams.toByteArray((InputStream)new URL(data.toString()).openStream());
        } else if (MIMEContainer.exists(data.toString())) {
            File imgFile = new File(data.toString());
            bytes = Files.toByteArray((File)imgFile);
        } else {
            throw new FileNotFoundException(data.toString() + " doesn't exist. ");
        }
        return bytes;
    }

    public String toString() {
        return (Object)((Object)this.getMime()) + " CODE = " + this.getCode();
    }

    public static enum MIME {
        TEXT_PLAIN("text/plain"),
        TEXT_HTML("text/html"),
        TEXT_LATEX("text/latex"),
        TEXT_MARKDOWN("text/markdown"),
        APPLICATION_JAVASCRIPT("application/javascript"),
        IMAGE_PNG("image/png"),
        IMAGE_JPEG("image/jpeg"),
        IMAGE_SVG("image/svg+xml"),
        HIDDEN("x-beakerx/empty");

        private String mime;

        private MIME(String mime) {
            this.mime = mime;
        }

        public String getMime() {
            return this.mime;
        }
    }
}

