/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)DateDeserializer.class.getName());

    public DateDeserializer(BeakerObjectConverter p) {
        p.addKnownBeakerType("Date");
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("Date");
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        Date o = null;
        try {
            if (n.has("timestamp")) {
                o = new Date(n.get("timestamp").asLong());
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing Date {}", (Object)e.getMessage());
        }
        return o;
    }
}

