/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.twosigma.beaker.jvm.object.OutputContainer;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import java.io.IOException;

public abstract class BasicOutputContainerSerializer<T extends OutputContainer>
extends JsonSerializer<T> {
    private final Provider<BeakerObjectConverter> objectSerializerProvider;

    @Inject
    public BasicOutputContainerSerializer(Provider<BeakerObjectConverter> osp) {
        this.objectSerializerProvider = osp;
    }

    protected BeakerObjectConverter getObjectSerializer() {
        return (BeakerObjectConverter)this.objectSerializerProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        T t = value;
        synchronized (t) {
            jgen.writeStartObject();
            jgen.writeObjectField("type", (Object)value.getClass().getSimpleName());
            this.serialize(value, jgen);
            jgen.writeArrayFieldStart("labels");
            if (((OutputContainer)value).getLabels() != null) {
                for (String label : ((OutputContainer)value).getLabels()) {
                    jgen.writeObject((Object)label);
                }
            }
            jgen.writeEndArray();
            jgen.writeArrayFieldStart("items");
            if (((OutputContainer)value).getItems() != null) {
                for (Object obj : ((OutputContainer)value).getItems()) {
                    if (this.getObjectSerializer().writeObject(obj, jgen, true)) continue;
                    jgen.writeObject((Object)obj.toString());
                }
            }
            jgen.writeEndArray();
            jgen.writeObjectField("layout", (Object)((OutputContainer)value).getLayoutManager());
            jgen.writeEndObject();
        }
    }

    protected abstract void serialize(T var1, JsonGenerator var2) throws IOException;
}

