/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.handler;

import com.twosigma.beaker.jupyter.commands.MagicCommand;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Scanner;
import java.util.concurrent.Semaphore;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private MagicCommand magicCommand;
    private int executionCount = 0;
    private final Semaphore syncObject = new Semaphore(1, true);

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
        this.magicCommand = new MagicCommand(kernel);
    }

    @Override
    public void handle(Message message) {
        try {
            this.handleMsg(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMsg(Message message) throws InterruptedException {
        this.syncObject.acquire();
        this.kernel.sendBusyMessage(message);
        ++this.executionCount;
        String code = this.code(message);
        this.announceThatWeHaveTheCode(message, code);
        if (this.isaMagicCommand(code)) {
            this.executeMagicCommand(message, code);
        } else {
            this.kernel.executeCode(code, message, this.executionCount, seo -> {
                this.kernel.sendIdleMessage(seo.getJupyterMessage());
                this.syncObject.release();
            });
        }
    }

    private void executeMagicCommand(Message message, String code) {
        String command = new Scanner(code).next();
        if (this.magicCommand.commands.containsKey(command)) {
            this.magicCommand.commands.get(command).process(code, message, this.executionCount);
        } else {
            this.magicCommand.processUnknownCommand(command, message, this.executionCount);
        }
    }

    private boolean isaMagicCommand(String code) {
        return code.startsWith("%");
    }

    private void announceThatWeHaveTheCode(Message message, String code) {
        Message reply = new Message();
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        reply.setHeader(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(2);
        map1.put("execution_count", Integer.valueOf(this.executionCount));
        map1.put("code", (Serializable)((Object)code));
        reply.setContent(map1);
        this.kernel.publish(reply);
    }

    private String code(Message message) {
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)((Object)message.getContent().get("code"))).trim();
        }
        return code;
    }

    @Override
    public void exit() {
    }
}

