/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.evaluator;

import com.twosigma.beaker.autocomplete.AutocompleteResult;
import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.KernelParameters;
import com.twosigma.jupyter.message.Message;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluatorManager {
    public static Logger logger = LoggerFactory.getLogger(EvaluatorManager.class);
    protected Evaluator evaluator = null;
    protected KernelFunctionality kernel;

    public EvaluatorManager(KernelFunctionality kernel, Evaluator evaluator) {
        this.kernel = kernel;
        this.evaluator = evaluator;
        evaluator.startWorker();
    }

    public synchronized void setShellOptions(KernelParameters kernelParameters) {
        try {
            this.evaluator.setShellOptions(kernelParameters);
        }
        catch (IOException e) {
            logger.error("Error while setting Shell Options", (Throwable)e);
        }
        this.evaluator.startWorker();
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.evaluator.autocomplete(code, caretPosition);
    }

    public synchronized void killAllThreads() {
        this.evaluator.killAllThreads();
    }

    public synchronized SimpleEvaluationObject executeCode(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject(code, executeCodeCallback);
        seo.setJupyterMessage(message);
        seo.setExecutionCount(executionCount);
        seo.addObserver(this.kernel.getExecutionResultSender());
        this.evaluator.evaluate(seo, code);
        return seo;
    }

    public void exit() {
        this.evaluator.exit();
    }
}

