/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.xychart.plotitem;

import com.twosigma.beaker.chart.xychart.plotitem.BasedXYGraphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XYStacker {
    public static List<BasedXYGraphics> stack(List<BasedXYGraphics> graphicsList) {
        return XYStacker.transformGraphicsList(graphicsList);
    }

    private static List<BasedXYGraphics> transformGraphicsList(List<BasedXYGraphics> graphicsList) {
        if (graphicsList.isEmpty() || graphicsList.size() == 1) {
            return graphicsList;
        }
        BasedXYGraphics graphicsWithMaxElements = Collections.max(graphicsList, new Comparator<BasedXYGraphics>(){

            @Override
            public int compare(BasedXYGraphics o1, BasedXYGraphics o2) {
                return o1.getY().size() - o2.getY().size();
            }
        });
        ArrayList<BasedXYGraphics> stackedList = new ArrayList<BasedXYGraphics>(graphicsList.size());
        XYStacker.padYs(graphicsList.get(0), graphicsWithMaxElements);
        stackedList.add(graphicsList.get(0));
        for (int gIndex = 1; gIndex < graphicsList.size(); ++gIndex) {
            BasedXYGraphics current = graphicsList.get(gIndex);
            XYStacker.padYs(current, graphicsWithMaxElements);
            BasedXYGraphics previous = graphicsList.get(gIndex - 1);
            List<Number> currentYs = current.getY();
            List<Number> previousYs = previous.getY();
            for (int yIndex = 0; yIndex < currentYs.size(); ++yIndex) {
                currentYs.set(yIndex, currentYs.get(yIndex).doubleValue() + previousYs.get(yIndex).doubleValue());
            }
            current.setBase(previousYs);
            stackedList.add(current);
        }
        return stackedList;
    }

    private static void padYs(BasedXYGraphics graphics, BasedXYGraphics graphicsWithMaxElements) {
        int currentSize;
        int maxSize = graphicsWithMaxElements.getY().size();
        int diff = maxSize - (currentSize = graphics.getY().size());
        if (diff > 0) {
            Object[] ys = new Number[diff];
            Arrays.fill(ys, graphics.getY().get(currentSize - 1));
            graphics.getY().addAll(Arrays.asList(ys));
            List<Number> xs = graphics.getX();
            if (xs != null && xs.size() != maxSize) {
                if (graphicsWithMaxElements.getX() != null) {
                    xs.addAll(graphicsWithMaxElements.getX().subList(currentSize, maxSize));
                } else {
                    Number lastX = xs.get(currentSize - 1);
                    for (int i = 0; i < diff; ++i) {
                        xs.add(lastX.doubleValue() + (double)i);
                    }
                }
            }
        }
    }
}

