/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import mpicbg.models.Point;
import mpicbg.models.Spring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex
extends Point {
    protected final HashMap<Vertex, Spring> springs = new HashMap();
    protected final double[] direction;
    protected double speed;
    private double forceSum;
    protected final double[] force;
    protected double forceAmplitude;

    public Collection<Spring> getSprings() {
        return this.springs.values();
    }

    public Set<Vertex> getConnectedVertices() {
        return this.springs.keySet();
    }

    public Spring getSpring(Vertex vertex) {
        return this.springs.get(vertex);
    }

    public void addSpring(Vertex v2, Spring spring) {
        this.springs.put(v2, spring);
        v2.springs.put(this, spring);
    }

    public void addSpring(Vertex v2, double[] weights) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weights));
    }

    public void addSpring(Vertex v2, double[] weights, double maxStretch) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weights, maxStretch));
    }

    public void addSpring(Vertex v2, double weight) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weight));
    }

    public void addSpring(Vertex v2, double weight, double maxStretch) {
        this.addSpring(v2, new Spring((Point)this, (Point)v2, weight, maxStretch));
    }

    public double[] getDirection() {
        return this.direction;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getForceSum() {
        return this.forceSum;
    }

    public double[] getForces() {
        return this.force;
    }

    public double getForce() {
        return this.forceAmplitude;
    }

    public Vertex(double[] l) {
        super(l);
        this.direction = new double[l.length];
        this.force = new double[this.direction.length];
    }

    public Vertex(double[] l, double[] w) {
        super(l, w);
        this.direction = new double[l.length];
        this.force = new double[this.direction.length];
    }

    public Vertex(Point point) {
        this(point.getL(), point.getW());
    }

    public void updateForce() {
        for (int i = 0; i < this.force.length; ++i) {
            this.force[i] = 0.0;
        }
        this.forceSum = 0.0;
        double[] f = new double[this.force.length];
        Set<Vertex> vertices = this.springs.keySet();
        for (Vertex vertex : vertices) {
            Spring spring = this.springs.get(vertex);
            spring.calculateForce(this, vertex, f);
            double fAmplitude = 0.0;
            for (int i = 0; i < this.force.length; ++i) {
                int n = i;
                this.force[n] = this.force[n] + f[i];
                fAmplitude += f[i] * f[i];
            }
            this.forceSum += Math.sqrt(fAmplitude);
        }
        this.forceAmplitude = 0.0;
        for (int i = 0; i < this.force.length; ++i) {
            this.forceAmplitude += this.force[i] * this.force[i];
        }
        this.forceAmplitude = Math.sqrt(this.forceAmplitude);
    }

    public void updateDirection(double dampDt, double dt) {
        this.speed = 0.0;
        for (int i = 0; i < this.force.length; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] + this.force[i] * dt;
            int n2 = i;
            this.direction[n2] = this.direction[n2] * dampDt;
            this.speed += this.direction[i] * this.direction[i];
        }
        this.speed = Math.sqrt(this.speed);
    }

    public void update(double damp, double dt) {
        this.updateForce();
        this.updateDirection(Math.pow(damp, dt), dt);
    }

    @Deprecated
    public void update(double damp) {
        for (int i = 0; i < this.force.length; ++i) {
            this.force[i] = 0.0;
        }
        this.forceSum = 0.0;
        double[] f = new double[this.force.length];
        Set<Vertex> vertices = this.springs.keySet();
        for (Vertex vertex : vertices) {
            Spring spring = this.springs.get(vertex);
            spring.calculateForce(this, vertex, f);
            double fAmplitude = 0.0;
            for (int i = 0; i < this.force.length; ++i) {
                int n = i;
                this.force[n] = this.force[n] + f[i];
                fAmplitude += f[i] * f[i];
            }
            this.forceSum += Math.sqrt(fAmplitude);
        }
        this.forceAmplitude = 0.0;
        this.speed = 0.0;
        for (int i = 0; i < this.force.length; ++i) {
            this.forceAmplitude += this.force[i] * this.force[i];
            int n = i;
            this.direction[n] = this.direction[n] + this.force[i];
            int n2 = i;
            this.direction[n2] = this.direction[n2] * damp;
            this.speed += this.direction[i] * this.direction[i];
        }
        this.forceAmplitude = Math.sqrt(this.forceAmplitude);
        this.speed = Math.sqrt(this.speed);
    }

    public final void move(double t) {
        for (int i = 0; i < this.w.length; ++i) {
            int n = i;
            this.w[n] = this.w[n] + t * this.direction[i];
        }
    }

    public final int traceConnectedGraph(Set<Vertex> graph) {
        graph.add(this);
        Set<Vertex> vertices = this.springs.keySet();
        for (Vertex vertex : vertices) {
            if (vertices.contains(vertex)) continue;
            vertex.traceConnectedGraph(graph);
        }
        return graph.size();
    }
}

