/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractMovingLeastSquaresTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingLeastSquaresTransform2
extends AbstractMovingLeastSquaresTransform {
    private static final long serialVersionUID = -8809482252029606075L;
    protected float[][] p;
    protected float[][] q;
    protected float[] w;

    @Override
    public final void setMatches(Collection<PointMatch> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int n = matches.size() > 0 ? matches.iterator().next().getP1().getL().length : 0;
        this.p = new float[n][matches.size()];
        this.q = new float[n][matches.size()];
        this.w = new float[matches.size()];
        int i = 0;
        for (PointMatch match : matches) {
            double[] pp = match.getP1().getL();
            double[] qq = match.getP2().getW();
            for (int d = 0; d < n; ++d) {
                this.p[d][i] = (float)pp[d];
                this.q[d][i] = (float)qq[d];
            }
            this.w[i] = (float)match.getWeight();
            ++i;
        }
        if (n <= 0) {
            throw new NotEnoughDataPointsException("No matches passed.");
        }
        this.model.fit(this.p, this.q, this.w);
    }

    public final void setMatches(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.p = p;
        this.q = q;
        this.w = w;
        this.model.fit(p, q, w);
    }

    @Override
    public void applyInPlace(double[] location) {
        float[] ww = new float[this.w.length];
        for (int i = 0; i < this.w.length; ++i) {
            int d;
            double s = 0.0;
            for (d = 0; d < location.length; ++d) {
                double dx = (double)this.p[d][i] - location[d];
                s += dx * dx;
            }
            if (s <= 0.0) {
                for (d = 0; d < location.length; ++d) {
                    location[d] = this.q[d][i];
                }
                return;
            }
            ww[i] = (float)((double)this.w[i] * this.weigh(s));
        }
        try {
            this.model.fit(this.p, this.q, ww);
            this.model.applyInPlace(location);
        }
        catch (IllDefinedDataPointsException e) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

