/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.Affine3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.InvertibleInterpolatedModel;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterpolatedAffineModel3D<A extends Model<A> & Affine3D<A>, B extends Model<B> & Affine3D<B>>
extends InvertibleInterpolatedModel<A, B, InterpolatedAffineModel3D<A, B>>
implements Affine3D<InterpolatedAffineModel3D<A, B>>,
InvertibleBoundable {
    private static final long serialVersionUID = -6834487125812773082L;
    protected final AffineModel3D affine = new AffineModel3D();
    protected final double[] afs = new double[12];
    protected final double[] bfs = new double[12];

    public InterpolatedAffineModel3D(A model, B regularizer, double lambda) {
        super(model, regularizer, lambda);
        this.interpolate();
    }

    protected void interpolate() {
        ((Affine3D)((Object)this.a)).toArray(this.afs);
        ((Affine3D)((Object)this.b)).toArray(this.bfs);
        for (int i = 0; i < this.afs.length; ++i) {
            this.afs[i] = this.afs[i] * this.l1 + this.bfs[i] * this.lambda;
        }
        this.affine.set(this.afs[0], this.afs[3], this.afs[6], this.afs[9], this.afs[1], this.afs[4], this.afs[7], this.afs[10], this.afs[2], this.afs[5], this.afs[8], this.afs[11]);
    }

    @Override
    public <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        super.fit(matches);
        this.interpolate();
    }

    @Override
    public void set(InterpolatedAffineModel3D<A, B> m) {
        super.set(m);
        if (InterpolatedAffineModel3D.class.isInstance(m)) {
            this.affine.set(m.affine);
        }
    }

    @Override
    public InterpolatedAffineModel3D<A, B> copy() {
        InterpolatedAffineModel3D copy = new InterpolatedAffineModel3D(this.a.copy(), this.b.copy(), this.lambda);
        copy.cost = this.cost;
        return copy;
    }

    @Override
    public double[] apply(double[] location) {
        double[] copy = (double[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(double[] location) {
        this.affine.applyInPlace(location);
    }

    @Override
    public double[] applyInverse(double[] point) throws NoninvertibleModelException {
        double[] copy = (double[])point.clone();
        this.applyInverseInPlace(copy);
        return copy;
    }

    @Override
    public void applyInverseInPlace(double[] point) throws NoninvertibleModelException {
        this.affine.applyInverseInPlace(point);
    }

    @Override
    public InterpolatedAffineModel3D<A, B> createInverse() {
        InterpolatedAffineModel3D<Model, Model> inverse = new InterpolatedAffineModel3D<Model, Model>((Model)((Affine3D)((Object)this.a)).createInverse(), (Model)((Affine3D)((Object)this.b)).createInverse(), this.lambda);
        inverse.cost = this.cost;
        return inverse;
    }

    public AffineModel3D createAffineModel3D() {
        return this.affine.copy();
    }

    @Override
    public void preConcatenate(InterpolatedAffineModel3D<A, B> affine3d) {
        this.affine.preConcatenate(affine3d.affine);
    }

    @Override
    public void concatenate(InterpolatedAffineModel3D<A, B> affine3d) {
        this.affine.concatenate(affine3d.affine);
    }

    @Override
    public void toArray(double[] data) {
        this.affine.toArray(data);
    }

    @Override
    public void toMatrix(double[][] data) {
        this.affine.toMatrix(data);
    }

    @Override
    public void estimateBounds(double[] min, double[] max) {
        this.affine.estimateBounds(min, max);
    }

    @Override
    public void estimateInverseBounds(double[] min, double[] max) throws NoninvertibleModelException {
        this.affine.estimateInverseBounds(min, max);
    }
}

