/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel1D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffineModel1D
extends AbstractAffineModel1D<AffineModel1D>
implements InvertibleBoundable {
    private static final long serialVersionUID = -6691788501310913119L;
    protected static final int MIN_NUM_MATCHES = 2;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double i00 = 1.0;
    protected double i01 = 0.0;
    protected boolean isInvertible = true;

    @Override
    public double[] getMatrix(double[] m) {
        double[] a = m == null || m.length != 2 ? new double[2] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        l[0] = l[0] * this.m00 + this.m01;
    }

    @Override
    public final double[] applyInverse(double[] l) throws NoninvertibleModelException {
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) throws NoninvertibleModelException {
        assert (l.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        l[0] = l[0] * this.i00 + this.i01;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 1 && q.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double qcx = 0.0;
        double ws = 0.0;
        double[] pX = p[0];
        double[] qX = q[0];
        for (int i = 0; i < l; ++i) {
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            qcx += ww * qX[i];
        }
        pcx /= ws;
        qcx /= ws;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < l; ++i) {
            double px = pX[i] - pcx;
            double qx = qX[i] - qcx;
            double wwpx = w[i] * px;
            a += wwpx * px;
            b += wwpx * qx;
        }
        if (a == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = b / a;
        this.m01 = qcx - this.m00 * pcx;
        this.invert();
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 1 && q.length >= 1) : "1d affine transformations can be applied to 1d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double qcx = 0.0;
        double ws = 0.0;
        float[] pX = p[0];
        float[] qX = q[0];
        for (int i = 0; i < l; ++i) {
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            qcx += ww * (double)qX[i];
        }
        pcx /= ws;
        qcx /= ws;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < l; ++i) {
            double px = (double)pX[i] - pcx;
            double qx = (double)qX[i] - qcx;
            double wwpx = (double)w[i] * px;
            a += wwpx * px;
            b += wwpx * qx;
        }
        if (a == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = b / a;
        this.m01 = qcx - this.m00 * pcx;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d affine model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double qcx = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            qcx += w * q[0];
        }
        pcx /= ws;
        qcx /= ws;
        double a = 0.0;
        double b = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double px = p[0] - pcx;
            double qx = q[0] - qcx;
            double wwpx = m.getWeight() * px;
            a += wwpx * px;
            b += wwpx * qx;
        }
        if (a == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = b / a;
        this.m01 = qcx - this.m00 * pcx;
        this.invert();
    }

    @Override
    public final void set(AffineModel1D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public AffineModel1D copy() {
        AffineModel1D m = new AffineModel1D();
        m.set(this);
        return m;
    }

    protected void invert() {
        if (this.m00 == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        this.i00 = 1.0 / this.m00;
        this.i01 = -this.m01 / this.m00;
    }

    @Override
    public final void preConcatenate(AffineModel1D model) {
        double a00 = model.m00 * this.m00;
        double a01 = model.m00 * this.m01 + model.m01;
        this.m00 = a00;
        this.m01 = a01;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel1D model) {
        double a00 = this.m00 * model.m00;
        double a01 = this.m00 * model.m01 + this.m01;
        this.m00 = a00;
        this.m01 = a01;
        this.invert();
    }

    public final void set(double m00, double m01) {
        this.m00 = m00;
        this.m01 = m01;
        this.invert();
    }

    public final String toString() {
        return "1d-affine: (" + this.m00 + ", " + this.m01 + ")";
    }

    @Override
    public AffineModel1D createInverse() {
        AffineModel1D ict = new AffineModel1D();
        ict.m00 = this.i00;
        ict.m01 = this.i01;
        ict.i00 = this.m00;
        ict.i01 = this.m01;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m01;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
    }
}

