/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;

public class FloatArray2DScaleOctave {
    public State state = State.EMPTY;
    public int width = 0;
    public int height = 0;
    private float K = 2.0f;
    private float K_MIN1_INV = 1.0f / (this.K - 1.0f);
    public int STEPS = 1;
    public float[] SIGMA;
    private float[] SIGMA_DIFF;
    private float[][] KERNEL_DIFF;
    private FloatArray2D[] l;
    private FloatArray2D[] d;
    private FloatArray2D[][] l1;

    public FloatArray2D[] getL() {
        return this.l;
    }

    public FloatArray2D getL(int i) {
        return this.l[i];
    }

    public FloatArray2D[] getD() {
        return this.d;
    }

    public FloatArray2D getD(int i) {
        return this.d[i];
    }

    public FloatArray2D[] getL1(int i) {
        if (this.l1[i] == null) {
            this.l1[i] = Filter.createGradients(this.l[i]);
        }
        return this.l1[i];
    }

    public FloatArray2DScaleOctave(FloatArray2D img, int steps, float initial_sigma) {
        this.state = State.EMPTY;
        this.width = img.width;
        this.height = img.height;
        this.STEPS = steps;
        this.K = (float)Math.pow(2.0, 1.0 / (double)this.STEPS);
        this.K_MIN1_INV = 1.0f / (this.K - 1.0f);
        this.SIGMA = new float[this.STEPS + 3];
        this.SIGMA[0] = initial_sigma;
        this.SIGMA_DIFF = new float[this.STEPS + 3];
        this.SIGMA_DIFF[0] = 0.0f;
        this.KERNEL_DIFF = new float[this.STEPS + 3][];
        for (int i = 1; i < this.STEPS + 3; ++i) {
            this.SIGMA[i] = initial_sigma * (float)Math.pow(2.0, (float)i / (float)this.STEPS);
            this.SIGMA_DIFF[i] = (float)Math.sqrt(this.SIGMA[i] * this.SIGMA[i] - initial_sigma * initial_sigma);
            this.KERNEL_DIFF[i] = Filter.createGaussianKernel(this.SIGMA_DIFF[i], true);
        }
        this.l = new FloatArray2D[1];
        this.l[0] = img;
        this.d = null;
        this.l1 = null;
    }

    public FloatArray2DScaleOctave(FloatArray2D img, float[] sigma, float[] sigma_diff, float[][] kernel_diff) {
        this.state = State.EMPTY;
        this.width = img.width;
        this.height = img.height;
        this.STEPS = sigma.length - 3;
        this.K = (float)Math.pow(2.0, 1.0 / (double)this.STEPS);
        this.K_MIN1_INV = 1.0f / (this.K - 1.0f);
        this.SIGMA = sigma;
        this.SIGMA_DIFF = sigma_diff;
        this.KERNEL_DIFF = kernel_diff;
        this.l = new FloatArray2D[1];
        this.l[0] = img;
        this.d = null;
        this.l1 = null;
    }

    public void buildStub() {
        FloatArray2D img = this.l[0];
        this.l = new FloatArray2D[2];
        this.l[0] = img;
        this.l[1] = Filter.convolveSeparable(this.l[0], this.KERNEL_DIFF[this.STEPS], this.KERNEL_DIFF[this.STEPS]);
        this.state = State.STUB;
    }

    public boolean build() {
        int i;
        FloatArray2D img = this.l[0];
        if (this.state == State.STUB) {
            FloatArray2D img2 = this.l[1];
            this.l = new FloatArray2D[this.STEPS + 3];
            this.l[this.STEPS] = img2;
        } else {
            this.l = new FloatArray2D[this.STEPS + 3];
        }
        this.l[0] = img;
        for (i = 1; i < this.SIGMA_DIFF.length; ++i) {
            if (this.state == State.STUB && i == this.STEPS) continue;
            this.l[i] = Filter.convolveSeparable(this.l[0], this.KERNEL_DIFF[i], this.KERNEL_DIFF[i]);
        }
        this.d = new FloatArray2D[this.STEPS + 2];
        for (i = 0; i < this.d.length; ++i) {
            this.d[i] = new FloatArray2D(this.l[i].width, this.l[i].height);
            int j = i + 1;
            for (int k = 0; k < this.l[i].data.length; ++k) {
                this.d[i].data[k] = (this.l[j].data[k] - this.l[i].data[k]) * this.K_MIN1_INV;
            }
        }
        this.l1 = new FloatArray2D[this.STEPS + 3][];
        for (i = 0; i < this.l1.length; ++i) {
            this.l1[i] = null;
        }
        this.state = State.COMPLETE;
        return true;
    }

    public void clear() {
        this.state = State.EMPTY;
        this.d = null;
        this.l = null;
        this.l1 = null;
    }

    public static void downsample(FloatArray2D src, FloatArray2D dst) {
        int ws = 2 * src.width;
        int rs = 0;
        for (int r = 0; r < dst.data.length; r += dst.width) {
            int xs = 0;
            for (int x = 0; x < dst.width; ++x) {
                dst.data[r + x] = src.data[rs + xs];
                xs += 2;
            }
            rs += ws;
        }
    }

    public static void upsample(FloatArray2D src, FloatArray2D dst) {
        int rdw;
        int rd1 = rdw = 2 * dst.width;
        int rd2 = dst.width;
        int xd1 = 2;
        int xd2 = 1;
        dst.data[0] = src.data[0];
        for (int xs1 = 1; xs1 < src.width; ++xs1) {
            int xs2 = xs1 - 1;
            dst.data[xd1] = src.data[xs1];
            dst.data[xd2] = (src.data[xs1] + src.data[xs2]) / 2.0f;
            xd1 += 2;
            xd2 += 2;
        }
        for (int rs1 = src.width; rs1 < src.data.length; rs1 += src.width) {
            int rs2 = rs1 - src.width;
            xd1 = 2;
            xd2 = 1;
            dst.data[rd1] = src.data[rs1];
            dst.data[rd2] = (src.data[rs1] + src.data[rs2]) / 2.0f;
            for (int xs1 = 1; xs1 < src.width; ++xs1) {
                int xs2 = xs1 - 1;
                dst.data[rd1 + xd1] = src.data[rs1 + xs1];
                dst.data[rd1 + xd2] = (src.data[rs1 + xs1] + src.data[rs1 + xs2]) / 2.0f;
                dst.data[rd2 + xd1] = (src.data[rs1 + xs1] + src.data[rs2 + xs1]) / 2.0f;
                dst.data[rd2 + xd2] = (src.data[rs1 + xs1] + src.data[rs2 + xs2]) / 2.0f;
                xd1 += 2;
                xd2 += 2;
            }
            rd1 += rdw;
            rd2 += rdw;
        }
        if (dst.height % 2 == 0) {
            rd1 = dst.data.length - dst.width;
            rd2 = rd1 - dst.width;
            for (xd1 = 0; xd1 < dst.width; ++xd1) {
                dst.data[rd1 + xd1] = dst.data[rd2 + xd1];
            }
        }
        if (dst.height % 2 == 0) {
            xd1 = dst.width - 1;
            xd2 = dst.width - 2;
            for (rd1 = 0; rd1 < dst.data.length; rd1 += dst.width) {
                dst.data[rd1 + xd1] = dst.data[rd1 + xd2];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        EMPTY,
        STUB,
        COMPLETE;

    }
}

