/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;

public class BlockStatistics {
    protected final DoubleIntegralImage sums;
    protected final DoubleIntegralImage sumsOfSquares;
    protected final FloatProcessor fp;

    protected final void integrateRows(int w1, int n, int width, double[] sum, double[] sumOfSquares) {
        int i = 0;
        for (int j = w1; j < n; ++j) {
            int end = i + width;
            double s = sum[j] = (double)this.fp.getf(i);
            double ss = sumOfSquares[j] = s * s;
            ++i;
            ++j;
            while (i < end) {
                float a = this.fp.getf(i);
                sum[j] = s += (double)a;
                sumOfSquares[j] = ss += (double)(a * a);
                ++i;
                ++j;
            }
        }
    }

    protected final void integrateRowsParallel(int w1, int n, int width, int height, double[] sum, double[] sumOfSquares) {
        int i = 0;
        for (int j = w1; j < n; ++j) {
            int end = i + width;
            double s = sum[j] = (double)this.fp.getf(i);
            double ss = sumOfSquares[j] = s * s;
            ++i;
            ++j;
            while (i < end) {
                float a = this.fp.getf(i);
                sum[j] = s += (double)a;
                sumOfSquares[j] = ss += (double)(a * a);
                ++i;
                ++j;
            }
        }
    }

    protected static final void integrateColumns(int w1, int w2, int n1, int n2, double[] sum, double[] sumOfSquares, int w) {
        for (int j = w1; j < w2; j -= n1) {
            int end = j + n2;
            double s = sum[j];
            double ss = sumOfSquares[j];
            j += w;
            while (j < end) {
                sum[j] = s += sum[j];
                sumOfSquares[j] = ss += sumOfSquares[j];
                j += w;
            }
        }
    }

    public BlockStatistics(FloatProcessor fp) {
        this.fp = fp;
        int width = fp.getWidth();
        int height = fp.getHeight();
        int w = width + 1;
        int w1 = w + 1;
        int w2 = w + w;
        int n = w * height + w;
        int n1 = n - w1;
        int n2 = n1 - w + 2;
        double[] sum = new double[n];
        double[] sumOfSquares = new double[n];
        this.integrateRows(w1, n, width, sum, sumOfSquares);
        BlockStatistics.integrateColumns(w1, w2, n1, n2, sum, sumOfSquares, w);
        this.sums = new DoubleIntegralImage(sum, width, height);
        this.sumsOfSquares = new DoubleIntegralImage(sumOfSquares, width, height);
    }

    public final void mean(int blockRadiusX, int blockRadiusY) {
        int width = this.fp.getWidth();
        int w = this.fp.getWidth() - 1;
        int h = this.fp.getHeight() - 1;
        for (int y = 0; y <= h; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x <= w; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                double scale = 1.0 / (double)(xMax - xMin) / (double)bh;
                this.fp.setf(row + x, (float)(scale * this.sums.getDoubleSum(xMin, yMin, xMax, yMax)));
            }
        }
    }

    public final void mean(int blockRadius) {
        this.mean(blockRadius, blockRadius);
    }

    public final void variance(int blockRadiusX, int blockRadiusY) {
        int width = this.fp.getWidth();
        int w = this.fp.getWidth() - 1;
        int h = this.fp.getHeight() - 1;
        for (int y = 0; y <= h; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x <= w; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                double scale = 1.0 / (double)(xMax - xMin) / (double)bh;
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale * (this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - sum * sum * scale);
                this.fp.setf(row + x, var < 0.0 ? 0.0f : (float)var);
            }
        }
    }

    public final void variance(int blockRadius) {
        this.variance(blockRadius, blockRadius);
    }

    public final void std(int blockRadiusX, int blockRadiusY) {
        int width = this.fp.getWidth();
        int w = this.fp.getWidth() - 1;
        int h = this.fp.getHeight() - 1;
        for (int y = 0; y <= h; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x <= w; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                this.fp.setf(row + x, var < 0.0 ? 0.0f : (float)Math.sqrt(var));
            }
        }
    }

    public final void std(int blockRadius) {
        this.std(blockRadius, blockRadius);
    }

    public final void sampleVariance(int blockRadiusX, int blockRadiusY) {
        int width = this.fp.getWidth();
        int w = this.fp.getWidth() - 1;
        int h = this.fp.getHeight() - 1;
        for (int y = 0; y <= h; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x <= w; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                this.fp.setf(row + x, var < 0.0 ? 0.0f : (float)var);
            }
        }
    }

    public final void sampleVariance(int blockRadius) {
        this.sampleVariance(blockRadius, blockRadius);
    }

    protected final class RowIntegrator
    extends Thread {
        protected final double[] sum;
        protected final double[] sumOfSquares;
        protected final int n;
        protected final int w1;
        protected final int width;
        public int i;

        public RowIntegrator(double[] sum, double[] sumOfSquares, int n, int w1, int width) {
            this.sum = sum;
            this.sumOfSquares = sumOfSquares;
            this.n = n;
            this.w1 = w1;
            this.width = width;
        }

        public void run() {
            for (int j = this.i + this.w1; j < this.n; ++j) {
                int end = this.i + this.width;
                double s = this.sum[j] = (double)BlockStatistics.this.fp.getf(this.i);
                double ss = this.sumOfSquares[j] = s * s;
                ++this.i;
                ++j;
                while (this.i < end) {
                    float a = BlockStatistics.this.fp.getf(this.i);
                    this.sum[j] = s += (double)a;
                    this.sumOfSquares[j] = ss += (double)(a * a);
                    ++this.i;
                    ++j;
                }
            }
        }
    }
}

