/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.ChoiceWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class, priority=0.0)
public class SwingChoiceWidget
extends SwingInputWidget<String>
implements ActionListener,
ChoiceWidget<JPanel> {
    public static final double PRIORITY = 0.0;
    private JComboBox<String> comboBox;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    public String getValue() {
        return this.comboBox.getSelectedItem().toString();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        String[] items = model.getChoices();
        this.comboBox = new JComboBox<String>(items);
        this.setToolTip(this.comboBox);
        this.getComponent().add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isText() && model.isMultipleChoice();
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (value.equals(this.comboBox.getSelectedItem())) {
            return;
        }
        this.comboBox.setSelectedItem(value);
    }
}

