/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.imagej.AbstractData;
import net.imagej.Dataset;
import net.imagej.DatasetFactory;
import net.imagej.Extents;
import net.imagej.ImgPlus;
import net.imagej.Position;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.event.DatasetCreatedEvent;
import net.imagej.event.DatasetDeletedEvent;
import net.imagej.event.DatasetRGBChangedEvent;
import net.imagej.event.DatasetRestructuredEvent;
import net.imagej.event.DatasetTypeChangedEvent;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.types.DataTypeService;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.display.ColorTable;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.Context;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class DefaultDataset
extends AbstractData
implements Dataset {
    @Parameter
    private LogService log;
    @Parameter
    private DataTypeService dataTypeService;
    private ImgPlus<? extends RealType<?>> imgPlus;
    private boolean rgbMerged;
    private boolean isDirty;

    public DefaultDataset(Context context, ImgPlus<? extends RealType<?>> imgPlus) {
        super(context, imgPlus);
        this.imgPlus = imgPlus;
        this.rgbMerged = this.mergedColorCompatible();
        this.isDirty = false;
    }

    @Override
    protected void register() {
        this.publish((SciJavaEvent)new DatasetCreatedEvent(this));
    }

    @Override
    protected void delete() {
        this.publish((SciJavaEvent)new DatasetDeletedEvent(this));
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    @Override
    public ImgPlus<? extends RealType<?>> getImgPlus() {
        return this.imgPlus;
    }

    @Override
    public <T extends RealType<T>> ImgPlus<T> typedImg(T t) {
        ImgPlus<RealType<?>> img = this.getImgPlus();
        if (t.getClass().isAssignableFrom(img.firstElement().getClass())) {
            ImgPlus<RealType<?>> typedImg = img;
            return typedImg;
        }
        return null;
    }

    @Override
    public void setImgPlus(ImgPlus<? extends RealType<?>> imgPlus) {
        boolean wasRgbMerged = this.isRGBMerged();
        boolean typeChanged = false;
        if (imgPlus.firstElement().getClass() != this.getType().getClass()) {
            typeChanged = true;
        }
        this.imgPlus = imgPlus;
        if (wasRgbMerged && !this.mergedColorCompatible()) {
            this.setRGBMerged(false);
        }
        this.rebuild();
        if (typeChanged) {
            this.typeChange();
        }
    }

    @Override
    public Object getPlane(int planeNumber) {
        return this.getPlane(planeNumber, true);
    }

    @Override
    public Object getPlane(int planeNumber, boolean copyOK) {
        PlanarAccess planarAccess;
        Object plane;
        Img<? extends RealType<?>> img = this.imgPlus.getImg();
        if (img instanceof PlanarAccess && (plane = (planarAccess = (PlanarAccess)img).getPlane(planeNumber)) instanceof ArrayDataAccess) {
            return ((ArrayDataAccess)plane).getCurrentStorageArray();
        }
        if (copyOK) {
            return this.copyOfPlane(planeNumber);
        }
        return null;
    }

    @Override
    public boolean setPlaneSilently(int planeNum, Object newPlane) {
        Img<? extends RealType<?>> img = this.imgPlus.getImg();
        if (!(img instanceof PlanarAccess)) {
            this.log.error((Object)"Cannot set plane for non-planar image");
            return false;
        }
        PlanarAccess planarAccess = (PlanarAccess)img;
        ArrayDataAccess arrayAccess = (ArrayDataAccess)planarAccess.getPlane(planeNum);
        Object currPlane = arrayAccess.getCurrentStorageArray();
        if (newPlane == currPlane) {
            return false;
        }
        ArrayDataAccess<?> array = this.createArrayDataAccess(newPlane);
        planarAccess.setPlane(planeNum, array);
        return true;
    }

    @Override
    public boolean setPlane(int planeNum, Object newPlane) {
        if (this.setPlaneSilently(planeNum, newPlane)) {
            this.update(false);
            return true;
        }
        return false;
    }

    @Override
    public RealType<?> getType() {
        return this.imgPlus.firstElement();
    }

    @Override
    public boolean isSigned() {
        return this.getType().getMinValue() < 0.0;
    }

    @Override
    public boolean isInteger() {
        return this.getType() instanceof IntegerType;
    }

    @Override
    public String getTypeLabelShort() {
        if (this.isRGBMerged()) {
            return "RGB";
        }
        NumericType type = (NumericType)this.getImgPlus().firstElement();
        return this.dataTypeService.getTypeByClass(type.getClass()).shortName();
    }

    @Override
    public String getTypeLabelLong() {
        if (this.isRGBMerged()) {
            return "RGB color";
        }
        NumericType type = (NumericType)this.getImgPlus().firstElement();
        return this.dataTypeService.getTypeByClass(type.getClass()).longName();
    }

    @Override
    public Dataset duplicate() {
        Img newImgPlus = this.imgPlus.copy();
        return new DefaultDataset(this.getContext(), (ImgPlus<? extends RealType<?>>)newImgPlus);
    }

    @Override
    public Dataset duplicateBlank() {
        ImgPlus<? extends RealType<?>> untypedImg = this.imgPlus;
        DefaultDataset d = new DefaultDataset(this.getContext(), DefaultDataset.createBlankCopy(untypedImg));
        d.setRGBMerged(this.isRGBMerged());
        return d;
    }

    @Override
    public void copyInto(Dataset target) {
        this.copyDataValues(this.imgPlus, target.getImgPlus());
        target.update();
    }

    @Override
    public void setRGBMerged(boolean rgbMerged) {
        if (rgbMerged == this.rgbMerged) {
            return;
        }
        if (rgbMerged && !this.mergedColorCompatible()) {
            throw new IllegalArgumentException("This dataset is not color compatible");
        }
        this.rgbMerged = rgbMerged;
        this.rgbChange();
    }

    @Override
    public boolean isRGBMerged() {
        return this.rgbMerged;
    }

    @Override
    public void typeChange() {
        this.setDirty(true);
        this.publish((SciJavaEvent)new DatasetTypeChangedEvent(this));
    }

    @Override
    public void rgbChange() {
        this.publish((SciJavaEvent)new DatasetRGBChangedEvent(this));
    }

    @Override
    public void copyDataFrom(Dataset other) {
        ImgFactory<? extends RealType<?>> factory = this.getImgPlus().factory();
        Img newImg = factory.create(Intervals.dimensionsAsLongArray((Dimensions)other), other.getType());
        this.copyDataValues(other.getImgPlus(), newImg);
        Axis[] calibAxes = new CalibratedAxis[other.numDimensions()];
        other.axes(calibAxes);
        CalibratedAxis[] calibAxesCopy = new CalibratedAxis[calibAxes.length];
        for (int i = 0; i < calibAxes.length; ++i) {
            calibAxesCopy[i] = calibAxes[i].copy();
        }
        ImgPlus newImgPlus = this.wrapAsImgPlus(newImg, calibAxesCopy);
        int count = other.getColorTableCount();
        newImgPlus.initializeColorTables(count);
        for (int i = 0; i < count; ++i) {
            newImgPlus.setColorTable(other.getColorTable(i), i);
        }
        this.setRGBMerged(other.isRGBMerged());
        this.setImgPlus(newImgPlus);
    }

    @Override
    public void update() {
        this.update(false);
    }

    @Override
    public void rebuild() {
        this.setDirty(true);
        this.publish((SciJavaEvent)new DatasetRestructuredEvent(this));
    }

    @Override
    public int dimensionIndex(AxisType axis) {
        return this.imgPlus.dimensionIndex(axis);
    }

    @Override
    public CalibratedAxis axis(int d) {
        return (CalibratedAxis)this.imgPlus.axis(d);
    }

    public void axes(CalibratedAxis[] axes) {
        this.imgPlus.axes(axes);
    }

    @Override
    public void setAxes(CalibratedAxis[] axes) {
        if (axes.length != this.numDimensions()) {
            throw new IllegalArgumentException("number of axes must match dimensionality of dataset");
        }
        boolean changes = false;
        for (int i = 0; i < axes.length; ++i) {
            if (((CalibratedAxis)this.imgPlus.axis(i)).equals(axes[i])) continue;
            changes = true;
            this.imgPlus.setAxis(axes[i], i);
        }
        if (changes) {
            this.rebuild();
        }
    }

    @Override
    public void setAxis(CalibratedAxis axis, int d) {
        if (axis.equals(this.imgPlus.axis(d))) {
            return;
        }
        this.imgPlus.setAxis(axis, d);
        this.update(true);
    }

    @Override
    public int numDimensions() {
        return this.imgPlus.numDimensions();
    }

    public long min(int d) {
        return this.imgPlus.min(d);
    }

    public void min(long[] min) {
        this.imgPlus.min(min);
    }

    public void min(Positionable min) {
        this.imgPlus.min(min);
    }

    public long max(int d) {
        return this.imgPlus.max(d);
    }

    public void max(long[] max) {
        this.imgPlus.max(max);
    }

    public void max(Positionable max) {
        this.imgPlus.max(max);
    }

    public void dimensions(long[] dimensions) {
        this.imgPlus.dimensions(dimensions);
    }

    public long dimension(int d) {
        return this.imgPlus.dimension(d);
    }

    @Override
    public double realMin(int d) {
        return this.imgPlus.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.imgPlus.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.imgPlus.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.imgPlus.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.imgPlus.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.imgPlus.realMax(max);
    }

    @Override
    public String getName() {
        return this.imgPlus.getName();
    }

    @Override
    public void setName(String name) {
        if (Objects.equals(name, this.imgPlus.getName())) {
            return;
        }
        this.imgPlus.setName(name);
        this.update(true);
    }

    @Override
    public String getSource() {
        return this.imgPlus.getSource();
    }

    @Override
    public void setSource(String source) {
        this.imgPlus.setSource(source);
    }

    @Override
    public int getValidBits() {
        int validBits = this.imgPlus.getValidBits();
        if (validBits > 0) {
            return validBits;
        }
        return this.getType().getBitsPerPixel();
    }

    @Override
    public void setValidBits(int bits) {
        this.imgPlus.setValidBits(bits);
    }

    @Override
    public double getChannelMinimum(int c) {
        return this.imgPlus.getChannelMinimum(c);
    }

    @Override
    public void setChannelMinimum(int c, double min) {
        this.imgPlus.setChannelMinimum(c, min);
    }

    @Override
    public double getChannelMaximum(int c) {
        return this.imgPlus.getChannelMaximum(c);
    }

    @Override
    public void setChannelMaximum(int c, double max) {
        this.imgPlus.setChannelMaximum(c, max);
    }

    @Override
    public int getCompositeChannelCount() {
        return this.imgPlus.getCompositeChannelCount();
    }

    @Override
    public void setCompositeChannelCount(int count) {
        this.imgPlus.setCompositeChannelCount(count);
    }

    @Override
    public ColorTable getColorTable(int no) {
        return this.imgPlus.getColorTable(no);
    }

    @Override
    public void setColorTable(ColorTable lut, int no) {
        this.imgPlus.setColorTable(lut, no);
    }

    @Override
    public void initializeColorTables(int count) {
        this.imgPlus.initializeColorTables(count);
    }

    @Override
    public int getColorTableCount() {
        return this.imgPlus.getColorTableCount();
    }

    @Override
    public double getBytesOfInfo() {
        double bitsPerPix = this.getType().getBitsPerPixel();
        long pixCount = 1L;
        for (int d = 0; d < this.numDimensions(); ++d) {
            pixCount *= this.dimension(d);
        }
        double totBits = bitsPerPix * (double)pixCount;
        return totBits / 8.0;
    }

    private ArrayDataAccess<?> createArrayDataAccess(Object newPlane) {
        if (newPlane instanceof byte[]) {
            return new ByteArray((byte[])newPlane);
        }
        if (newPlane instanceof short[]) {
            return new ShortArray((short[])newPlane);
        }
        if (newPlane instanceof int[]) {
            return new IntArray((int[])newPlane);
        }
        if (newPlane instanceof float[]) {
            return new FloatArray((float[])newPlane);
        }
        if (newPlane instanceof long[]) {
            return new LongArray((long[])newPlane);
        }
        if (newPlane instanceof double[]) {
            return new DoubleArray((double[])newPlane);
        }
        return null;
    }

    private void copyDataValues(Img<? extends RealType<?>> input, Img<? extends RealType<?>> output) {
        long[] position = new long[output.numDimensions()];
        Cursor outputCursor = output.localizingCursor();
        RandomAccess inputAccessor = input.randomAccess();
        while (outputCursor.hasNext()) {
            outputCursor.next();
            outputCursor.localize(position);
            inputAccessor.setPosition(position);
            double value = ((RealType)inputAccessor.get()).getRealDouble();
            ((RealType)outputCursor.get()).setReal(value);
        }
    }

    private Object copyOfPlane(int planeNum) {
        long[] dimensions = new long[this.imgPlus.numDimensions()];
        this.imgPlus.dimensions(dimensions);
        long w = dimensions[0];
        long h = dimensions[1];
        if (w * h > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't create an in memory plane of " + w * h + " entities (MAX = " + Integer.MAX_VALUE + ")");
        }
        RealType<?> type = this.getType();
        if (!(type instanceof NativeType)) {
            return null;
        }
        NativeType nativeType = (NativeType)type;
        ArrayImgFactory storageFactory = new ArrayImgFactory();
        ArrayImg container = (ArrayImg)nativeType.createSuitableNativeImg((NativeImgFactory)storageFactory, new long[]{w, h});
        RandomAccess<? extends RealType<?>> input = this.imgPlus.randomAccess();
        ArrayRandomAccess output = container.randomAccess();
        long[] planeIndexSpans = new long[dimensions.length - 2];
        for (int i = 0; i < planeIndexSpans.length; ++i) {
            planeIndexSpans[i] = dimensions[i + 2];
        }
        Extents planeExtents = new Extents(planeIndexSpans);
        long[] planePos = new long[planeExtents.numDimensions()];
        Position pos = planeExtents.createPosition();
        pos.setIndex(planeNum);
        pos.localize(planePos);
        long[] inputPos = new long[dimensions.length];
        for (int i = 2; i < dimensions.length; ++i) {
            inputPos[i] = planePos[i - 2];
        }
        long[] outputPos = new long[2];
        input.setPosition(inputPos);
        output.setPosition(outputPos);
        RealType inputRef = (RealType)input.get();
        RealType outputRef = (RealType)output.get();
        int maxX = (int)(w - 1L);
        int maxY = (int)(h - 1L);
        for (int y = 0; y <= maxY; ++y) {
            for (int x = 0; x <= maxX; ++x) {
                double value = inputRef.getRealDouble();
                outputRef.setReal(value);
                if (x == maxX) continue;
                input.move(1, 0);
                output.move(1, 0);
            }
            if (y == maxY) continue;
            input.move(-maxX, 0);
            output.move(-maxX, 0);
            input.move(1, 1);
            output.move(1, 1);
        }
        ArrayDataAccess store = (ArrayDataAccess)container.update(null);
        return store.getCurrentStorageArray();
    }

    private static <T extends RealType<T>> ImgPlus<T> createBlankCopy(ImgPlus<T> img) {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        Img blankImg = img.factory().create(dimensions, img.firstElement());
        return new ImgPlus(blankImg, img);
    }

    private <T extends RealType<?>> ImgPlus<T> wrapAsImgPlus(Img<T> newImg, CalibratedAxis ... calibAxes) {
        return new ImgPlus<T>(newImg, this.getName(), calibAxes);
    }

    private void update(boolean metadataOnly) {
        this.setDirty(true);
        this.publish((SciJavaEvent)new DatasetUpdatedEvent(this, metadataOnly));
    }

    private boolean mergedColorCompatible() {
        if (this.isSigned()) {
            return false;
        }
        if (!this.isInteger()) {
            return false;
        }
        if (this.getType().getBitsPerPixel() != 8) {
            return false;
        }
        if (this.imgPlus.dimensionIndex(Axes.CHANNEL) < 0) {
            return false;
        }
        return this.imgPlus.dimension(this.dimensionIndex(Axes.CHANNEL)) == 3L;
    }

    public Img<RealType<?>> copy() {
        Img copy = this.getImgPlus().copy();
        return new DefaultDataset(this.getContext(), (ImgPlus<? extends RealType<?>>)copy);
    }

    @Override
    public DatasetFactory factory() {
        return new DatasetFactory(){

            @Override
            public Dataset create(long[] dim, RealType<?> type) {
                ImgPlus<RealType<?>> imp = this.makeImgPlus(dim, type);
                return new DefaultDataset(DefaultDataset.this.getContext(), imp);
            }

            public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
                return this;
            }

            private <T> ImgPlus<T> makeImgPlus(long[] dim, T type) {
                ImgFactory factory;
                try {
                    factory = DefaultDataset.this.getImgPlus().factory().imgFactory(type);
                }
                catch (IncompatibleTypeException exc) {
                    throw new IllegalStateException("Ill-understood type weirdness", exc);
                }
                Img img = factory.create(dim, type);
                return img instanceof ImgPlus ? (ImgPlus)img : new ImgPlus(img, DefaultDataset.this.getImgPlus());
            }
        };
    }

    public RandomAccess<RealType<?>> randomAccess() {
        return this.getImgPlus().randomAccess();
    }

    public RandomAccess<RealType<?>> randomAccess(Interval interval) {
        return this.getImgPlus().randomAccess(interval);
    }

    public Cursor<RealType<?>> cursor() {
        return this.getImgPlus().cursor();
    }

    public Cursor<RealType<?>> localizingCursor() {
        return this.getImgPlus().localizingCursor();
    }

    public RealType<?> firstElement() {
        return this.getImgPlus().firstElement();
    }

    public Object iterationOrder() {
        return this.getImgPlus().iterationOrder();
    }

    public long size() {
        return this.getImgPlus().size();
    }

    public Iterator<RealType<?>> iterator() {
        return this.getImgPlus().iterator();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.imgPlus.getProperties();
    }
}

