/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.bushe.swing.event.EventService;

public abstract class EventServiceAction
extends AbstractAction {
    public static final String EVENT_SERVICE_TOPIC_NAME = "event-service-topic";
    private boolean throwsExceptionOnNullEventService = true;
    public static final String EVENT_BUS_EVENT_CLASS_NAME = "eventBus.eventClassName";
    private String topicName;
    private boolean publishesOnTopic = true;

    public EventServiceAction() {
    }

    public EventServiceAction(String actionName, ImageIcon icon) {
        super(actionName, icon);
    }

    protected abstract EventService getEventService(ActionEvent var1);

    public boolean isPublishesOnTopic() {
        return this.publishesOnTopic;
    }

    public void setPublishesOnTopic(boolean onTopic) {
        this.publishesOnTopic = onTopic;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getTopicName(ActionEvent event) {
        if (this.topicName != null) {
            return this.topicName;
        }
        Object topic = this.getValue(EVENT_SERVICE_TOPIC_NAME);
        if (topic != null) {
            return topic + "";
        }
        topic = this.getValue("ID");
        if (topic != null) {
            return topic + "";
        }
        topic = this.getValue("ActionCommandKey");
        if (topic != null) {
            return topic + "";
        }
        topic = event.getActionCommand();
        if (topic != null) {
            return topic + "";
        }
        return (String)this.getName();
    }

    protected Object getTopicValue(ActionEvent event) {
        return event;
    }

    public Object getName() {
        return this.getValue("Name");
    }

    protected Object getEventServiceEvent(ActionEvent event) {
        return event;
    }

    public void actionPerformed(ActionEvent event) {
        EventService eventService = this.getEventService(event);
        if (eventService == null) {
            if (this.getThrowsExceptionOnNullEventService()) {
                throw new RuntimeException("Null EventService supplied to EventServiceAction with name:" + this.getName());
            }
            return;
        }
        if (this.isPublishesOnTopic()) {
            String topic = this.getTopicName(event);
            Object topicValue = this.getTopicValue(event);
            eventService.publish(topic, topicValue);
        } else {
            Object esEvent = this.getEventServiceEvent(event);
            eventService.publish(esEvent);
        }
    }

    public boolean getThrowsExceptionOnNullEventService() {
        return this.throwsExceptionOnNullEventService;
    }

    public void setThrowsExceptionOnNullEventService(boolean throwsExceptionOnNullEventService) {
        this.throwsExceptionOnNullEventService = throwsExceptionOnNullEventService;
    }
}

