/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology.eulerCharacteristic;

import java.util.stream.LongStream;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.EulerCorrection.class)
public class EulerCorrection<B extends BooleanType<B>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, DoubleType>
implements Ops.Topology.EulerCorrection,
Contingent {
    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 3;
    }

    @Override
    public void compute(RandomAccessibleInterval<B> interval, DoubleType output) {
        Traverser<B> traverser = new Traverser<B>(interval);
        long chiZero = EulerCorrection.stackCorners(traverser);
        long e = EulerCorrection.stackEdges(traverser) + 3L * chiZero;
        long d = EulerCorrection.voxelEdgeIntersections(traverser) + chiZero;
        long c = (long)EulerCorrection.stackFaces(traverser) + 2L * e - 3L * chiZero;
        long b = EulerCorrection.voxelEdgeFaceIntersections(traverser);
        long a = EulerCorrection.voxelFaceIntersections(traverser);
        long chiOne = d - e;
        long chiTwo = a - b + c;
        output.set((double)chiTwo / 2.0 + (double)chiOne / 4.0 + (double)chiZero / 8.0);
    }

    @Override
    public DoubleType createOutput(RandomAccessibleInterval<B> input) {
        return new DoubleType(0.0);
    }

    public static <B extends BooleanType<B>> int stackCorners(Traverser<B> traverser) {
        int foregroundVoxels = 0;
        traverser.getClass();
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, 0L, 0L);
        long l = traverser.x1;
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l, 0L, 0L);
        long l2 = traverser.x1;
        long l3 = traverser.y1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l2, l3, 0L);
        traverser.getClass();
        long l4 = traverser.y1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, l4, 0L);
        traverser.getClass();
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, 0L, traverser.z1);
        long l5 = traverser.x1;
        traverser.getClass();
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, l5, 0L, traverser.z1);
        foregroundVoxels += EulerCorrection.getAtLocation(traverser, traverser.x1, traverser.y1, traverser.z1);
        traverser.getClass();
        return foregroundVoxels += EulerCorrection.getAtLocation(traverser, 0L, traverser.y1, traverser.z1);
    }

    public static <B extends BooleanType<B>> long stackEdges(Traverser<B> traverser) {
        long[] foregroundVoxels = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.y1;
            LongStream.of(lArray).forEach(y -> {
                for (long x = 1L; x < traverser.x1; ++x) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.z1;
        LongStream.of(lArray2).forEach(z -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                for (long y = 1L; y < traverser.y1; ++y) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                for (long z = 1L; z < traverser.z1; ++z) {
                    foregroundVoxels[0] = foregroundVoxels[0] + (long)EulerCorrection.getAtLocation(traverser, x, y, z);
                }
            });
        });
        return foregroundVoxels[0];
    }

    public static <B extends BooleanType<B>> int stackFaces(Traverser<B> traverser) {
        int[] foregroundVoxels = new int[]{0};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            int y = 1;
            while ((long)y < traverser.y1) {
                int x = 1;
                while ((long)x < traverser.x1) {
                    foregroundVoxels[0] = foregroundVoxels[0] + EulerCorrection.getAtLocation(traverser, x, y, z);
                    ++x;
                }
                ++y;
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.y1;
        LongStream.of(lArray2).forEach(y -> {
            int z = 1;
            while ((long)z < traverser.z1) {
                int x = 1;
                while ((long)x < traverser.x1) {
                    foregroundVoxels[0] = foregroundVoxels[0] + EulerCorrection.getAtLocation(traverser, x, y, z);
                    ++x;
                }
                ++z;
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.x1;
        LongStream.of(lArray3).forEach(x -> {
            int y = 1;
            while ((long)y < traverser.y1) {
                int z = 1;
                while ((long)z < traverser.z1) {
                    foregroundVoxels[0] = foregroundVoxels[0] + EulerCorrection.getAtLocation(traverser, x, y, z);
                    ++z;
                }
                ++y;
            }
        });
        return foregroundVoxels[0];
    }

    public static <B extends BooleanType<B>> long voxelEdgeIntersections(Traverser<B> traverser) {
        int[] voxelVertices = new int[]{0};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            traverser.access.setPosition(z, 2);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.y1;
            LongStream.of(lArray).forEach(y -> {
                traverser.access.setPosition(y, 1);
                for (long x = 1L; x < traverser.xSize; ++x) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x - 1L, y, z);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.z1;
        LongStream.of(lArray2).forEach(z -> {
            traverser.access.setPosition(z, 2);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                traverser.access.setPosition(x, 0);
                for (long y = 1L; y < traverser.ySize; ++y) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y - 1L, z);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            traverser.access.setPosition(y, 1);
            long[] lArray = new long[2];
            traverser.getClass();
            lArray[0] = 0L;
            lArray[1] = traverser.x1;
            LongStream.of(lArray).forEach(x -> {
                traverser.access.setPosition(x, 0);
                for (long z = 1L; z < traverser.zSize; ++z) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y, z - 1L);
                    voxelVertices[0] = voxelVertices[0] + (voxelA | voxelB);
                }
            });
        });
        return voxelVertices[0];
    }

    public static <B extends BooleanType<B>> long voxelEdgeFaceIntersections(Traverser<B> traverser) {
        long[] voxelEdges = new long[]{0L};
        long[] iterations = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            int y = 0;
            while ((long)y <= traverser.ySize) {
                int x = 0;
                while ((long)x <= traverser.xSize) {
                    int voxel = EulerCorrection.getAtLocation(traverser, x, y, z);
                    if (voxel > 0) {
                        iterations[0] = iterations[0] + 1L;
                        voxelEdges[0] = voxelEdges[0] + 2L;
                    } else {
                        voxelEdges[0] = voxelEdges[0] + (long)EulerCorrection.getAtLocation(traverser, x, y - 1, z);
                        voxelEdges[0] = voxelEdges[0] + (long)EulerCorrection.getAtLocation(traverser, x - 1, y, z);
                    }
                    ++x;
                }
                ++y;
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.y1;
        LongStream.of(lArray2).forEach(y -> {
            int x = 0;
            while ((long)x < traverser.xSize) {
                int z = 1;
                while ((long)z < traverser.zSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y, z - 1);
                    voxelEdges[0] = voxelEdges[0] + (long)(voxelA | voxelB);
                    ++z;
                }
                ++x;
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            traverser.access.setPosition(y, 1);
            int z = 0;
            while ((long)z < traverser.zSize) {
                traverser.access.setPosition(z, 2);
                int x = 0;
                while ((long)x <= traverser.xSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x - 1, y, z);
                    voxelEdges[0] = voxelEdges[0] + (long)(voxelA | voxelB);
                    ++x;
                }
                ++z;
            }
        });
        long[] lArray4 = new long[2];
        traverser.getClass();
        lArray4[0] = 0L;
        lArray4[1] = traverser.x1;
        LongStream.of(lArray4).forEach(x -> {
            traverser.access.setPosition(x, 0);
            int y = 0;
            while ((long)y < traverser.ySize) {
                traverser.access.setPosition(y, 1);
                int z = 1;
                while ((long)z < traverser.zSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y, z - 1);
                    voxelEdges[0] = voxelEdges[0] + (long)(voxelA | voxelB);
                    ++z;
                }
                ++y;
            }
        });
        long[] lArray5 = new long[2];
        traverser.getClass();
        lArray5[0] = 0L;
        lArray5[1] = traverser.x1;
        LongStream.of(lArray5).forEach(x -> {
            traverser.access.setPosition(x, 0);
            int z = 0;
            while ((long)z < traverser.zSize) {
                traverser.access.setPosition(z, 2);
                int y = 1;
                while ((long)y < traverser.ySize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y - 1, z);
                    voxelEdges[0] = voxelEdges[0] + (long)(voxelA | voxelB);
                    ++y;
                }
                ++z;
            }
        });
        return voxelEdges[0];
    }

    public static <B extends BooleanType<B>> long voxelFaceIntersections(Traverser<B> traverser) {
        long[] voxelFaces = new long[]{0L};
        long[] lArray = new long[2];
        traverser.getClass();
        lArray[0] = 0L;
        lArray[1] = traverser.z1;
        LongStream.of(lArray).forEach(z -> {
            traverser.access.setPosition(z, 2);
            int y = 0;
            while ((long)y <= traverser.ySize) {
                int x = 0;
                while ((long)x <= traverser.xSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x - 1, y, z);
                    int voxelC = EulerCorrection.getAtLocation(traverser, x, y - 1, z);
                    int voxelD = EulerCorrection.getAtLocation(traverser, x - 1, y - 1, z);
                    voxelFaces[0] = voxelFaces[0] + (long)(voxelA | voxelB | voxelC | voxelD);
                    ++x;
                }
                ++y;
            }
        });
        long[] lArray2 = new long[2];
        traverser.getClass();
        lArray2[0] = 0L;
        lArray2[1] = traverser.x1;
        LongStream.of(lArray2).forEach(x -> {
            traverser.access.setPosition(x, 0);
            int y = 0;
            while ((long)y <= traverser.ySize) {
                int z = 1;
                while ((long)z < traverser.zSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y - 1, z);
                    int voxelC = EulerCorrection.getAtLocation(traverser, x, y, z - 1);
                    int voxelD = EulerCorrection.getAtLocation(traverser, x, y - 1, z - 1);
                    voxelFaces[0] = voxelFaces[0] + (long)(voxelA | voxelB | voxelC | voxelD);
                    ++z;
                }
                ++y;
            }
        });
        long[] lArray3 = new long[2];
        traverser.getClass();
        lArray3[0] = 0L;
        lArray3[1] = traverser.y1;
        LongStream.of(lArray3).forEach(y -> {
            int x = 1;
            while ((long)x < traverser.xSize) {
                int z = 1;
                while ((long)z < traverser.zSize) {
                    int voxelA = EulerCorrection.getAtLocation(traverser, x, y, z);
                    int voxelB = EulerCorrection.getAtLocation(traverser, x, y, z - 1);
                    int voxelC = EulerCorrection.getAtLocation(traverser, x - 1, y, z);
                    int voxelD = EulerCorrection.getAtLocation(traverser, x - 1, y, z - 1);
                    voxelFaces[0] = voxelFaces[0] + (long)(voxelA | voxelB | voxelC | voxelD);
                    ++z;
                }
                ++x;
            }
        });
        return voxelFaces[0];
    }

    private static <B extends BooleanType<B>> int getAtLocation(Traverser<B> traverser, long x, long y, long z) {
        traverser.access.setPosition(x, 0);
        traverser.access.setPosition(y, 1);
        traverser.access.setPosition(z, 2);
        double realDouble = ((BooleanType)traverser.access.get()).getRealDouble();
        return (int)realDouble;
    }

    public static class Traverser<B extends BooleanType<B>> {
        public final long x0 = 0L;
        public final long y0 = 0L;
        public final long z0 = 0L;
        public final long x1;
        public final long y1;
        public final long z1;
        public final long xSize;
        public final long ySize;
        public final long zSize;
        public final RandomAccess<B> access;

        public Traverser(RandomAccessibleInterval<B> interval) {
            this.xSize = interval.dimension(0);
            this.ySize = interval.dimension(1);
            this.zSize = interval.dimension(2);
            this.x1 = this.xSize - 1L;
            this.y1 = this.ySize - 1L;
            this.z1 = this.zSize - 1L;
            this.access = Views.extendZero(interval).randomAccess();
        }
    }
}

