/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.BoundarySize.class, label="Geometric (2D): Perimeter")
public class DefaultPerimeterLength
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.BoundarySize {
    @Override
    public void compute(Polygon input, DoubleType output) {
        double perimeter = 0.0;
        List vertices = input.getVertices();
        int size = vertices.size();
        for (int i = 0; i < size; ++i) {
            int nexti = (i + 1) % size;
            double dx2 = ((RealLocalizable)vertices.get(nexti)).getDoublePosition(0) - ((RealLocalizable)vertices.get(i)).getDoublePosition(0);
            double dy2 = ((RealLocalizable)vertices.get(nexti)).getDoublePosition(1) - ((RealLocalizable)vertices.get(i)).getDoublePosition(1);
            perimeter += Math.sqrt(dx2 * dx2 + dy2 * dy2);
        }
        output.set(perimeter);
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

