/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Centroid.class, label="Geometric: Centroid")
public class CentroidMesh
extends AbstractUnaryFunctionOp<Mesh, RealLocalizable>
implements Ops.Geometric.Centroid,
Contingent {
    private UnaryFunctionOp<Mesh, DoubleType> sizeFunc;

    @Override
    public void initialize() {
        this.sizeFunc = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
    }

    @Override
    public RealLocalizable calculate(Mesh input) {
        double c_x = 0.0;
        double c_y = 0.0;
        double c_z = 0.0;
        for (int i = 0; i < input.getFacets().size(); ++i) {
            TriangularFacet f = (TriangularFacet)input.getFacets().get(i);
            Vector3D normal = f.getNormal();
            Vector3D a = f.getP0();
            Vector3D b = f.getP1();
            Vector3D c = f.getP2();
            c_x += 0.041666666666666664 * normal.getX() * (Math.pow(a.getX() + b.getX(), 2.0) + Math.pow(b.getX() + c.getX(), 2.0) + Math.pow(c.getX() + a.getX(), 2.0));
            c_y += 0.041666666666666664 * normal.getY() * (Math.pow(a.getY() + b.getY(), 2.0) + Math.pow(b.getY() + c.getY(), 2.0) + Math.pow(c.getY() + a.getY(), 2.0));
            c_z += 0.041666666666666664 * normal.getZ() * (Math.pow(a.getZ() + b.getZ(), 2.0) + Math.pow(b.getZ() + c.getZ(), 2.0) + Math.pow(c.getZ() + a.getZ(), 2.0));
        }
        double d = 1.0 / (2.0 * this.sizeFunc.calculate(input).get());
        return new RealPoint(new double[]{-(c_x *= d), -(c_y *= d), -(c_z *= d)});
    }

    @Override
    public boolean conforms() {
        return ((Mesh)this.in()).triangularFacets();
    }
}

