/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    private final Map<Signal, SignalHandler> original = new HashMap<Signal, SignalHandler>();

    @Override
    public IRubyObject trap(IRubyObject recv2, IRubyObject blk, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), new JRubySignalHandler(recv2.getRuntime(), blk, sig.toString()));
    }

    @Override
    public IRubyObject trap(Ruby runtime, BlockCallback blk, String sig) {
        return this.trap(runtime, new JRubySignalHandler(runtime, blk, sig));
    }

    private IRubyObject trap(Ruby runtime, JRubySignalHandler handler) {
        return this.trap(runtime, handler.signal, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject restorePlatformDefault(IRubyObject recv2, IRubyObject sig) {
        SignalHandler handler;
        Map<Signal, SignalHandler> map = this.original;
        synchronized (map) {
            handler = this.original.get(new Signal(sig.toString()));
        }
        if (handler != null) {
            return this.trap(recv2.getRuntime(), sig.toString(), handler);
        }
        return recv2.getRuntime().getNil();
    }

    @Override
    public IRubyObject restoreOSDefault(IRubyObject recv2, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), sig.toString(), SignalHandler.SIG_DFL);
    }

    @Override
    public IRubyObject ignore(IRubyObject recv2, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), sig.toString(), SignalHandler.SIG_IGN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject trap(final Ruby runtime, String signalName, SignalHandler handler) {
        SignalHandler oldHandler;
        Signal signal2;
        try {
            signal2 = new Signal(signalName);
        }
        catch (Throwable e) {
            return runtime.getNil();
        }
        try {
            oldHandler = Signal.handle(signal2, handler);
        }
        catch (Exception e) {
            throw runtime.newArgumentError(e.getMessage());
        }
        Map<Signal, SignalHandler> e = this.original;
        synchronized (e) {
            if (!this.original.containsKey(signal2)) {
                this.original.put(signal2, oldHandler);
            }
        }
        BlockCallback callback = null;
        if (oldHandler instanceof JRubySignalHandler) {
            JRubySignalHandler jsHandler = (JRubySignalHandler)oldHandler;
            if (jsHandler.blockCallback != null) {
                callback = jsHandler.blockCallback;
            } else {
                return jsHandler.block;
            }
        }
        if (callback == null) {
            callback = new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                    oldHandler.handle(signal2);
                    return runtime.getNil();
                }
            };
        }
        RubyModule signalModule = runtime.getModule("Signal");
        Block block = CallBlock.newCallClosure(signalModule, signalModule, Arity.noArguments(), callback, runtime.getCurrentContext());
        return RubyProc.newProc(runtime, block, block.type);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final String signal;
        private final BlockCallback blockCallback;

        public JRubySignalHandler(Ruby runtime, IRubyObject block, String signal2) {
            this(runtime, block, null, signal2);
        }

        public JRubySignalHandler(Ruby runtime, BlockCallback callback, String signal2) {
            this(runtime, null, callback, signal2);
        }

        private JRubySignalHandler(Ruby runtime, IRubyObject block, BlockCallback callback, String signal2) {
            this.runtime = runtime;
            this.block = block;
            this.blockCallback = callback;
            this.signal = signal2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Signal signal2) {
            ThreadContext context = this.runtime.getCurrentContext();
            try {
                if (this.block != null) {
                    this.block.callMethod(context, "call");
                } else {
                    this.blockCallback.call(context, new IRubyObject[0], Block.NULL_BLOCK);
                }
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                Signal.handle(new Signal(this.signal), this);
            }
        }
    }
}

