/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeThread
implements ThreadLike {
    private Reference<Thread> nativeThread;
    public RubyThread rubyThread;

    public NativeThread(RubyThread rubyThread, IRubyObject[] args2, Block block) {
        throw new RuntimeException();
    }

    public NativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.nativeThread = new WeakReference<Thread>(nativeThread);
    }

    @Override
    public void start() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.start();
        }
    }

    @Override
    public void interrupt() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    @Override
    public boolean isAlive() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isAlive();
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join();
        }
    }

    @Override
    public void join(long timeoutMillis) throws InterruptedException {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.join(timeoutMillis);
        }
    }

    @Override
    public int getPriority() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.getPriority();
        }
        return 0;
    }

    @Override
    public void setPriority(int priority2) {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            thread2.setPriority(priority2);
        }
    }

    @Override
    public boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    @Override
    public boolean isInterrupted() {
        Thread thread2 = this.getThread();
        if (thread2 != null) {
            return thread2.isInterrupted();
        }
        return false;
    }

    public Thread getThread() {
        return this.nativeThread.get();
    }

    public String toString() {
        return "" + this.getThread();
    }

    @Override
    public Thread nativeThread() {
        return this.nativeThread.get();
    }
}

