/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.main.run;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.run.AbstractCodeRunner;
import org.scijava.run.CodeRunner;
import org.scijava.util.ClassUtils;

@Plugin(type=CodeRunner.class, priority=-100.0)
public class MainCodeRunner
extends AbstractCodeRunner {
    @Parameter(required=false)
    private LogService log;

    @Override
    public void run(Object code, Object ... args) throws InvocationTargetException {
        String[] sArgs = this.stringify(args);
        try {
            this.getMain(code).invoke(null, new Object[]{sArgs});
        }
        catch (IllegalArgumentException exc) {
            throw new InvocationTargetException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new InvocationTargetException(exc);
        }
    }

    @Override
    public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
        throw new UnsupportedOperationException("Cannot execute main method with a map of inputs");
    }

    @Override
    public boolean supports(Object code) {
        return this.getMain(code) != null;
    }

    private Method getMain(Object code) {
        Class<?> c = this.getClass(code);
        if (c == null) {
            return null;
        }
        try {
            return c.getMethod("main", String[].class);
        }
        catch (SecurityException exc) {
            if (this.log != null) {
                this.log.debug(exc);
            }
            return null;
        }
        catch (NoSuchMethodException exc) {
            if (this.log != null) {
                this.log.debug(exc);
            }
            return null;
        }
    }

    private Class<?> getClass(Object code) {
        if (code instanceof Class) {
            return (Class)code;
        }
        if (code instanceof String) {
            return ClassUtils.loadClass((String)code);
        }
        return null;
    }

    private String[] stringify(Object ... o) {
        String[] s;
        if (o == null) {
            s = null;
        } else {
            s = new String[o.length];
            for (int i = 0; i < o.length; ++i) {
                s[i] = o[i] == null ? null : (o[i] instanceof String ? (String)o[i] : o[i].toString());
            }
        }
        return s;
    }
}

