/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.units;

import java.util.HashMap;
import java.util.Map;
import net.imagej.units.Calibrator;
import net.imagej.units.LinearCalibrator;
import net.imagej.units.UnitService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import ucar.units.ConversionException;
import ucar.units.NoSuchUnitException;
import ucar.units.PrefixDBException;
import ucar.units.SpecificationException;
import ucar.units.Unit;
import ucar.units.UnitDBException;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitParseException;
import ucar.units.UnitSystemException;
import ucar.units.UnknownUnit;

@Plugin(type=Service.class)
public class DefaultUnitService
extends AbstractService
implements UnitService {
    @Parameter
    private LogService log;
    private Map<String, UnitDef> userDefinedUnits = new HashMap<String, UnitDef>();
    private UnitFormat unitFormatter = UnitFormatManager.instance();

    @Override
    public double value(double inputValue, String inputUnit, String outputUnit) {
        return this.findConversion(inputValue, inputUnit, outputUnit);
    }

    @Override
    public void defineUnit(String unitName, String baseUnit, double scale) {
        this.defineUnit(unitName, baseUnit, scale, 0.0);
    }

    @Override
    public void defineUnit(String unitName, String baseUnit, double scale, double offset) {
        this.defineUnit(unitName, baseUnit, new LinearCalibrator(scale, offset));
    }

    @Override
    public void defineUnit(String unitName, String baseUnit, Calibrator calibrator) {
        String err = null;
        if (this.userDefinedUnits.get(baseUnit) == null) {
            if (!this.definedInternally(baseUnit)) {
                err = "base unit has not been defined: " + baseUnit;
            }
        } else if (this.userDefinedUnits.get(unitName) != null) {
            err = "unit has already been defined: " + unitName;
        } else if (this.definedInternally(unitName)) {
            err = "can't redefine internal unit " + unitName;
        }
        if (err != null) {
            throw new IllegalArgumentException(err);
        }
        UnitDef unitDef = new UnitDef(baseUnit, calibrator);
        this.userDefinedUnits.put(unitName, unitDef);
    }

    private double findConversion(double measure, String unit1, String unit2) {
        UnitDef unit = this.userDefinedUnits.get(unit1);
        if (unit != null) {
            return this.findConversion(unit.calibrator.toOutput(measure), unit.baseUnit, unit2);
        }
        unit = this.userDefinedUnits.get(unit2);
        if (unit != null) {
            return this.findConversion(unit.calibrator.toInput(measure), unit1, unit.baseUnit);
        }
        try {
            Unit u1 = this.parseUnit(unit1);
            Unit u2 = this.parseUnit(unit2);
            return u1.convertTo(measure, u2);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean definedInternally(String unitName) {
        Unit o = this.parseUnit(unitName);
        if (o == null || o instanceof UnknownUnit) {
            return false;
        }
        return !(o.getDerivedUnit() instanceof UnknownUnit);
    }

    private Unit parseUnit(String unitName) {
        try {
            return this.unitFormatter.parse(unitName);
        }
        catch (NoSuchUnitException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        catch (UnitParseException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        catch (SpecificationException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        catch (UnitDBException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        catch (PrefixDBException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        catch (UnitSystemException exc) {
            this.log.error((Object)("Cannot parse unit: " + unitName), (Throwable)exc);
        }
        return null;
    }

    private class UnitDef {
        String baseUnit;
        Calibrator calibrator;

        UnitDef(String baseUnit, Calibrator calibrator) {
            this.baseUnit = baseUnit;
            this.calibrator = calibrator;
        }
    }
}

