/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.autoscale;

import net.imagej.autoscale.AbstractAutoscaleMethod;
import net.imagej.autoscale.AutoscaleMethod;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imglib2.IterableInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=AutoscaleMethod.class, name="Confidence Interval")
public class ConfidenceIntervalAutoscaleMethod<T extends RealType<T>>
extends AbstractAutoscaleMethod<T> {
    private double lowerTail;
    private double upperTail;
    @Parameter
    private AutoscaleService autoscaleService;

    public ConfidenceIntervalAutoscaleMethod() {
        this(0.025, 0.025);
    }

    public ConfidenceIntervalAutoscaleMethod(double lowerTailProportion, double upperTailProportion) {
        this.setTailProportions(lowerTailProportion, upperTailProportion);
    }

    public double getLowerTailProportion() {
        return this.lowerTail;
    }

    public double getUpperTailProportion() {
        return this.upperTail;
    }

    public void setTailProportions(double lower, double upper) {
        if (lower < 0.0 || lower > 1.0) {
            throw new IllegalArgumentException("lower tail fraction must be between 0 and 1");
        }
        if (upper < 0.0 || upper > 1.0) {
            throw new IllegalArgumentException("upper tail fraction must be between 0 and 1");
        }
        if (lower + upper >= 1.0) {
            throw new IllegalArgumentException("tails must not span whole data range");
        }
        this.lowerTail = lower;
        this.upperTail = upper;
    }

    @Override
    public DataRange getRange(IterableInterval<T> interval) {
        long soFar;
        DataRange range = this.autoscaleService.getDefaultIntervalRange(interval);
        Real1dBinMapper mapper = new Real1dBinMapper(range.getMin(), range.getMax(), 1000L, false);
        Histogram1d<T> histogram = new Histogram1d<T>(mapper);
        histogram.countData(interval);
        long totValues = histogram.distributionCount();
        long lowerSize = (long)Math.floor(this.lowerTail * (double)totValues);
        long upperSize = (long)Math.floor(this.upperTail * (double)totValues);
        int bottom = 0;
        for (soFar = 0L; soFar < lowerSize; soFar += histogram.frequency(bottom++)) {
        }
        while (histogram.frequency(bottom) == 0L) {
            ++bottom;
        }
        int top = 999;
        for (soFar = 0L; soFar < upperSize; soFar += histogram.frequency(top--)) {
        }
        while (histogram.frequency(top) == 0L) {
            --top;
        }
        RealType approxMin = (RealType)((RealType)interval.firstElement()).createVariable();
        RealType approxMax = (RealType)approxMin.createVariable();
        histogram.getLowerBound(bottom, approxMin);
        histogram.getUpperBound(top, approxMax);
        double min = approxMin.getRealDouble();
        double max = approxMax.getRealDouble();
        return new DataRange(min, max);
    }
}

