/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.img.cell.SCIFIOCell;
import net.imglib2.img.Img;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.AbstractCells;
import net.imglib2.img.list.AbstractListImg;
import net.imglib2.util.Fraction;
import net.imglib2.util.IntervalIndexer;

public class SCIFIOImgCells<A extends ArrayDataAccess<?>>
extends AbstractCells<A, SCIFIOCell<A>, CachedCells> {
    private final CachedCells cells;
    private final CellCache<A> cache;

    public SCIFIOImgCells(CellCache<A> cache, Fraction entitiesPerPixel, long[] dimensions, int[] cellDimensions) {
        super(entitiesPerPixel, dimensions, cellDimensions);
        this.cache = cache;
        this.cells = new CachedCells(this.numCells);
    }

    protected CachedCells cells() {
        return this.cells;
    }

    public class CachedCells
    extends AbstractListImg<SCIFIOCell<A>> {
        protected CachedCells(long[] dim) {
            super(dim);
        }

        protected SCIFIOCell<A> get(int index) {
            SCIFIOCell cell = SCIFIOImgCells.this.cache.get(index);
            if (cell != null) {
                return cell;
            }
            long[] cellGridPosition = new long[this.n];
            long[] cellMin = new long[this.n];
            int[] cellDims = new int[this.n];
            IntervalIndexer.indexToPosition((int)index, (int[])this.dim, (long[])cellGridPosition);
            SCIFIOImgCells.this.getCellDimensions(cellGridPosition, cellMin, cellDims);
            return SCIFIOImgCells.this.cache.load(index, cellDims, cellMin);
        }

        protected void set(int index, SCIFIOCell<A> value) {
            throw new UnsupportedOperationException("Not supported");
        }

        public Img<SCIFIOCell<A>> copy() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public static interface CellCache<A extends ArrayDataAccess<?>> {
        public SCIFIOCell<A> get(int var1);

        public SCIFIOCell<A> load(int var1, int[] var2, long[] var3);
    }
}

