/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.BufferedImagePlane;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.gui.Index16ColorModel;
import io.scif.gui.SignedByteBuffer;
import io.scif.gui.SignedColorModel;
import io.scif.gui.SignedShortBuffer;
import io.scif.gui.TwoChannelColorSpace;
import io.scif.gui.UnsignedIntBuffer;
import io.scif.gui.UnsignedIntColorModel;
import io.scif.gui.XYCTuple;
import io.scif.util.FormatTools;
import io.scif.util.ImageTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Hashtable;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import org.scijava.util.Bytes;

public final class AWTImageTools {
    private static final Component OBS = new Container();

    private AWTImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new byte[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new short[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, boolean signed) {
        return AWTImageTools.makeImage(new int[][]{data}, w, h, signed);
    }

    public static BufferedImage makeImage(float[] data, int w, int h) {
        return AWTImageTools.makeImage(new float[][]{data}, w, h);
    }

    public static BufferedImage makeImage(double[] data, int w, int h) {
        return AWTImageTools.makeImage(new double[][]{data}, w, h);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        if (c > 2) {
            return AWTImageTools.makeRGBImage(data, c, w, h, interleaved);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, c * w * h) : new DataBufferByte(data, c * w * h);
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, c * w * h);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, c * w * h);
        }
        return AWTImageTools.constructImage(c, dataType, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h, signed);
        }
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, c * w * h) : new UnsignedIntBuffer(data, c * w * h);
        return AWTImageTools.constructImage(c, 3, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h);
        return AWTImageTools.constructImage(c, 4, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h);
        return AWTImageTools.constructImage(c, 5, w, h, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, boolean signed) {
        if (data.length > 2) {
            return AWTImageTools.makeRGBImage(data, w, h);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, data[0].length) : new DataBufferByte(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, data[0].length);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, data[0].length);
        }
        return AWTImageTools.constructImage(data.length, dataType, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h, boolean signed) {
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, data[0].length) : new UnsignedIntBuffer(data, data[0].length);
        return AWTImageTools.constructImage(data.length, 3, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return AWTImageTools.constructImage(data.length, 4, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return AWTImageTools.constructImage(data.length, 5, w, h, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h, int c, boolean interleaved, int bpp, boolean fp, boolean little, boolean signed) {
        Object pixels = Bytes.makeArray((byte[])data, (int)(bpp % 3 == 0 ? bpp / 3 : bpp), (boolean)fp, (boolean)little);
        if (pixels instanceof byte[]) {
            return AWTImageTools.makeImage((byte[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof short[]) {
            return AWTImageTools.makeImage((short[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof int[]) {
            return AWTImageTools.makeImage((int[])pixels, w, h, c, interleaved, signed);
        }
        if (pixels instanceof float[]) {
            return AWTImageTools.makeImage((float[])pixels, w, h, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return AWTImageTools.makeImage((double[])pixels, w, h, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h, int bpp, boolean fp, boolean little, boolean signed) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = Bytes.makeArray((byte[])data[i], (int)(bpp % 3 == 0 ? bpp / 3 : bpp), (boolean)fp, (boolean)little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return AWTImageTools.makeImage(v, w, h, signed);
        }
        if (v instanceof short[][]) {
            return AWTImageTools.makeImage((short[][])v, w, h, signed);
        }
        if (v instanceof int[][]) {
            return AWTImageTools.makeImage((int[][])v, w, h, signed);
        }
        if (v instanceof float[][]) {
            return AWTImageTools.makeImage(v, w, h);
        }
        if (v instanceof double[][]) {
            return AWTImageTools.makeImage((double[][])v, w, h);
        }
        return null;
    }

    public static BufferedImage makeRGBImage(byte[] data, int c, int w, int h, boolean interleaved) {
        int cc = Math.min(c, 4);
        int[] buf = new int[data.length / c];
        int nBits = (cc - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < cc; ++q) {
                if (interleaved) {
                    int n = i;
                    buf[n] = buf[n] | (data[i * c + q] & 0xFF) << nBits - q * 8;
                    continue;
                }
                int n = i;
                buf[n] = buf[n] | (data[q * buf.length + i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(cc, 3, w, h, false, false, buffer);
    }

    public static BufferedImage makeRGBImage(byte[][] data, int w, int h) {
        int[] buf = new int[data[0].length];
        int nBits = (data.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < data.length; ++q) {
                int n = i;
                buf[n] = buf[n] | (data[q][i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(data.length, 3, w, h, false, false, buffer);
    }

    public static BufferedImage blankImage(ImageMetadata meta, long[] axes, int type) {
        XYCTuple xyc = new XYCTuple(meta, axes);
        int c = xyc.c();
        int w = xyc.x();
        int h = xyc.y();
        switch (type) {
            case 0: {
                return AWTImageTools.makeImage(new byte[c][w * h], w, h, true);
            }
            case 1: {
                return AWTImageTools.makeImage(new byte[c][w * h], w, h, false);
            }
            case 2: {
                return AWTImageTools.makeImage(new short[c][w * h], w, h, true);
            }
            case 3: {
                return AWTImageTools.makeImage(new short[c][w * h], w, h, false);
            }
            case 4: {
                return AWTImageTools.makeImage(new int[c][w * h], w, h, true);
            }
            case 5: {
                return AWTImageTools.makeImage(new int[c][w * h], w, h, false);
            }
            case 6: {
                return AWTImageTools.makeImage(new float[c][w * h], w, h);
            }
            case 7: {
                return AWTImageTools.makeImage(new double[c][w * h], w, h);
            }
        }
        return null;
    }

    public static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer) {
        return AWTImageTools.constructImage(c, type, w, h, interleaved, banded, buffer, null);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h, boolean interleaved, boolean banded, DataBuffer buffer, ColorModel colorModel) {
        int[] bandOffsets;
        SampleModel model;
        int i;
        if (c > 4) {
            throw new IllegalArgumentException("Cannot construct image with " + c + " channels");
        }
        if (colorModel == null || colorModel instanceof DirectColorModel) {
            colorModel = AWTImageTools.makeColorModel(c, type);
            if (colorModel == null) {
                return null;
            }
            if (buffer instanceof UnsignedIntBuffer) {
                colorModel = new UnsignedIntColorModel(32, type, c);
            }
        }
        if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            int[] bitMasks = new int[c];
            for (i = 0; i < c; ++i) {
                bitMasks[i] = 255 << (c - i - 1) * 8;
            }
            model = new SinglePixelPackedSampleModel(3, w, h, bitMasks);
        } else if (banded) {
            model = new BandedSampleModel(type, w, h, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h;
            }
            model = new ComponentSampleModel(type, w, h, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage b = null;
        if (c == 1 && type == 0 && !(buffer instanceof SignedByteBuffer)) {
            b = colorModel instanceof IndexColorModel ? new BufferedImage(w, h, 13) : new BufferedImage(w, h, 10);
            b.setData(raster);
        } else if (c == 1 && type == 1) {
            if (!(colorModel instanceof IndexColorModel)) {
                b = new BufferedImage(w, h, 11);
                b.setData(raster);
            }
        } else if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            if (c == 3) {
                b = new BufferedImage(w, h, 1);
            } else if (c == 4) {
                b = new BufferedImage(w, h, 2);
            }
            if (b != null) {
                b.setData(raster);
            }
        }
        if (b == null) {
            b = new BufferedImage(colorModel, raster, false, null);
        }
        return b;
    }

    public static BufferedImage openImage(Plane plane, Reader r, int imageIndex) throws FormatException, IOException {
        long[] lengths = r.getMetadata().get(imageIndex).getAxesLengthsPlanar();
        return AWTImageTools.openImage(plane, r, lengths, imageIndex);
    }

    public static BufferedImage openImage(Plane plane, Reader r, long[] axes, int imageIndex) throws FormatException, IOException {
        return AWTImageTools.openImage(plane, plane.getBytes(), r, axes, imageIndex);
    }

    public static BufferedImage openImage(Plane plane, byte[] bytes, Reader r, long[] axes, int imageIndex) throws FormatException, IOException {
        int bpp;
        BufferedImage b;
        Metadata meta = r.getMetadata();
        XYCTuple whc = new XYCTuple(meta.get(imageIndex), axes);
        int w = whc.x();
        int h = whc.y();
        int rgbChanCount = whc.c();
        int pixelType = meta.get(imageIndex).getPixelType();
        boolean little = meta.get(imageIndex).isLittleEndian();
        boolean normal = r.isNormalized();
        boolean interleaved = meta.get(imageIndex).getInterleavedAxisCount() > 0;
        boolean indexed = meta.get(imageIndex).isIndexed();
        if (pixelType == 6) {
            float[] f = (float[])Bytes.makeArray((byte[])bytes, (int)4, (boolean)true, (boolean)little);
            if (normal) {
                f = Bytes.normalize((float[])f);
            }
            return AWTImageTools.makeImage(f, w, h, rgbChanCount, interleaved);
        }
        if (pixelType == 7) {
            double[] d = (double[])Bytes.makeArray((byte[])bytes, (int)8, (boolean)true, (boolean)little);
            if (normal) {
                d = Bytes.normalize((double[])d);
            }
            return AWTImageTools.makeImage(d, w, h, rgbChanCount, interleaved);
        }
        boolean signed = FormatTools.isSigned(pixelType);
        ColorModel model = null;
        if (signed) {
            if (pixelType == 0) {
                model = new SignedColorModel(8, 0, rgbChanCount);
            } else if (pixelType == 2) {
                model = new SignedColorModel(16, 2, rgbChanCount);
            } else if (pixelType == 4) {
                model = new SignedColorModel(32, 3, rgbChanCount);
            }
        }
        if ((b = AWTImageTools.makeImage(bytes, w, h, rgbChanCount, interleaved, bpp = FormatTools.getBytesPerPixel(pixelType), false, little, signed)) == null) {
            throw new FormatException("Could not construct BufferedImage");
        }
        if (indexed && rgbChanCount == 1) {
            short[][] table;
            ColorTable ct = plane.getColorTable();
            if (ColorTable8.class.isAssignableFrom(ct.getClass())) {
                byte[][] table2 = (byte[][])((ColorTable8)ct).getValues();
                if (table2 != null && table2.length > 0 && table2[0] != null) {
                    int len = table2[0].length;
                    byte[] dummy = table2.length < 3 ? new byte[len] : null;
                    byte[] red = table2.length >= 1 ? table2[0] : dummy;
                    byte[] green = table2.length >= 2 ? table2[1] : dummy;
                    byte[] blue = table2.length >= 3 ? table2[2] : dummy;
                    model = new IndexColorModel(8, len, red, green, blue);
                }
            } else if (ColorTable16.class.isAssignableFrom(ct.getClass()) && (table = (short[][])((ColorTable16)ct).getValues()) != null && table.length > 0 && table[0] != null) {
                model = new Index16ColorModel(16, table[0].length, table, meta.get(imageIndex).isLittleEndian());
            }
        }
        if (indexed && rgbChanCount == 1 && BufferedImagePlane.class.isAssignableFrom(plane.getClass())) {
            model = ((BufferedImage)((BufferedImagePlane)plane).getData()).getColorModel();
        }
        if (model != null) {
            WritableRaster raster = Raster.createWritableRaster(b.getSampleModel(), b.getRaster().getDataBuffer(), null);
            b = new BufferedImage(model, raster, false, null);
        }
        return b;
    }

    public static BufferedImage openThumbImage(Plane plane, Reader r, int imageIndex, long[] axes, int thumbSizeX, int thumbSizeY, boolean pad) throws FormatException, IOException {
        BufferedImage img = AWTImageTools.openImage(plane, r, axes, imageIndex);
        img = AWTImageTools.makeUnsigned(img);
        img = AWTImageTools.scale(img, thumbSizeX, thumbSizeY, pad);
        return img;
    }

    public static Object getPixels(BufferedImage image) {
        return AWTImageTools.getPixels(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public static Object getPixels(BufferedImage image, int x, int y, int w, int h) {
        WritableRaster raster = image.getRaster();
        return AWTImageTools.getPixels(raster, x, y, w, h);
    }

    public static Object getPixels(WritableRaster raster) {
        return AWTImageTools.getPixels(raster, 0, 0, raster.getWidth(), raster.getHeight());
    }

    public static Object getPixels(WritableRaster raster, int x, int y, int w, int h) {
        int tt = raster.getTransferType();
        if (tt == 0) {
            return AWTImageTools.getBytes(raster, x, y, w, h);
        }
        if (tt == 1 || tt == 2) {
            return AWTImageTools.getShorts(raster, x, y, w, h);
        }
        if (tt == 3) {
            return AWTImageTools.getInts(raster, x, y, w, h);
        }
        if (tt == 4) {
            return AWTImageTools.getFloats(raster, x, y, w, h);
        }
        if (tt == 5) {
            return AWTImageTools.getDoubles(raster, x, y, w, h);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getBytes(r);
    }

    public static byte[][] getBytes(WritableRaster r) {
        return AWTImageTools.getBytes(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getBytes(WritableRaster r, int x, int y, int w, int h) {
        if (AWTImageTools.canUseBankDataDirectly(r, 0, DataBufferByte.class) && x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getShorts(r);
    }

    public static short[][] getShorts(WritableRaster r) {
        return AWTImageTools.getShorts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static short[][] getShorts(WritableRaster r, int x, int y, int w, int h) {
        if (AWTImageTools.canUseBankDataDirectly(r, 1, DataBufferUShort.class) && x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h];
        int[] buf = new int[w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getInts(r);
    }

    public static int[][] getInts(WritableRaster r) {
        return AWTImageTools.getInts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static int[][] getInts(WritableRaster r, int x, int y, int w, int h) {
        if (AWTImageTools.canUseBankDataDirectly(r, 3, DataBufferInt.class) && x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getFloats(r);
    }

    public static float[][] getFloats(WritableRaster r) {
        return AWTImageTools.getFloats(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static float[][] getFloats(WritableRaster r, int x, int y, int w, int h) {
        if (AWTImageTools.canUseBankDataDirectly(r, 4, DataBufferFloat.class) && x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getDoubles(r);
    }

    public static double[][] getDoubles(WritableRaster r) {
        return AWTImageTools.getDoubles(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static double[][] getDoubles(WritableRaster r, int x, int y, int w, int h) {
        if (AWTImageTools.canUseBankDataDirectly(r, 5, DataBufferDouble.class) && x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h, i, samples[i]);
        }
        return samples;
    }

    private static boolean canUseBankDataDirectly(WritableRaster r, int transferType, Class<? extends DataBuffer> dataBufferClass) {
        int i;
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == 0) continue;
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        return AWTImageTools.getPixelBytes(img, little, 0, 0, img.getWidth(), img.getHeight());
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little) {
        return AWTImageTools.getPixelBytes(r, little, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little, int x, int y, int w, int h) {
        byte[][] pixelBytes;
        block14: {
            Object pixels;
            block17: {
                block16: {
                    int imageType;
                    block15: {
                        block13: {
                            pixels = AWTImageTools.getPixels(img, x, y, w, h);
                            imageType = img.getType();
                            pixelBytes = null;
                            if (!(pixels instanceof byte[][])) break block13;
                            pixelBytes = (byte[][])pixels;
                            break block14;
                        }
                        if (!(pixels instanceof short[][])) break block15;
                        short[][] s = (short[][])pixels;
                        pixelBytes = new byte[s.length][s[0].length * 2];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < s[0].length; ++j) {
                                Bytes.unpack((long)s[i][j], (byte[])pixelBytes[i], (int)(j * 2), (int)2, (boolean)little);
                            }
                        }
                        break block14;
                    }
                    if (!(pixels instanceof int[][])) break block16;
                    int[][] in = (int[][])pixels;
                    if (imageType == 1 || imageType == 4 || imageType == 2) {
                        pixelBytes = new byte[in.length][in[0].length];
                        for (int c = 0; c < in.length; ++c) {
                            for (int i = 0; i < in[0].length; ++i) {
                                if (imageType != 4) {
                                    pixelBytes[c][i] = (byte)(in[c][i] & 0xFF);
                                    continue;
                                }
                                pixelBytes[in.length - c - 1][i] = (byte)(in[c][i] & 0xFF);
                            }
                        }
                    } else {
                        pixelBytes = new byte[in.length][in[0].length * 4];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < in[0].length; ++j) {
                                Bytes.unpack((long)in[i][j], (byte[])pixelBytes[i], (int)(j * 4), (int)4, (boolean)little);
                            }
                        }
                    }
                    break block14;
                }
                if (!(pixels instanceof float[][])) break block17;
                float[][] in = (float[][])pixels;
                pixelBytes = new byte[in.length][in[0].length * 4];
                for (int i = 0; i < pixelBytes.length; ++i) {
                    for (int j = 0; j < in[0].length; ++j) {
                        int v = Float.floatToIntBits(in[i][j]);
                        Bytes.unpack((long)v, (byte[])pixelBytes[i], (int)(j * 4), (int)4, (boolean)little);
                    }
                }
                break block14;
            }
            if (!(pixels instanceof double[][])) break block14;
            double[][] in = (double[][])pixels;
            pixelBytes = new byte[in.length][in[0].length * 8];
            for (int i = 0; i < pixelBytes.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    Bytes.unpack((long)v, (byte[])pixelBytes[i], (int)(j * 8), (int)8, (boolean)little);
                }
            }
        }
        return pixelBytes;
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little, int x, int y, int w, int h) {
        Object in;
        int j;
        int i;
        Object pixels = AWTImageTools.getPixels(r);
        byte[][] pixelBytes = null;
        int bpp = 0;
        if (pixels instanceof byte[][]) {
            pixelBytes = (byte[][])pixels;
            bpp = 1;
        } else if (pixels instanceof short[][]) {
            bpp = 2;
            short[][] s = (short[][])pixels;
            pixelBytes = new byte[s.length][s[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < s[0].length; ++j) {
                    Bytes.unpack((long)s[i][j], (byte[])pixelBytes[i], (int)(j * bpp), (int)bpp, (boolean)little);
                }
            }
        } else if (pixels instanceof int[][]) {
            bpp = 4;
            in = (int[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    Bytes.unpack((long)in[i][j], (byte[])pixelBytes[i], (int)(j * bpp), (int)bpp, (boolean)little);
                }
            }
        } else if (pixels instanceof float[][]) {
            bpp = 4;
            in = (float[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    Bytes.unpack((long)v, (byte[])pixelBytes[i], (int)(j * bpp), (int)bpp, (boolean)little);
                }
            }
        } else if (pixels instanceof double[][]) {
            bpp = 8;
            in = (double[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    Bytes.unpack((long)v, (byte[])pixelBytes[i], (int)(j * bpp), (int)bpp, (boolean)little);
                }
            }
        }
        if (x == 0 && y == 0 && w == r.getWidth() && h == r.getHeight()) {
            return pixelBytes;
        }
        byte[][] croppedBytes = new byte[pixelBytes.length][w * h * bpp];
        for (int c = 0; c < croppedBytes.length; ++c) {
            for (int row = 0; row < h; ++row) {
                int src = (row + y) * r.getWidth() * bpp + x * bpp;
                int dest = row * w * bpp;
                System.arraycopy(pixelBytes[c], src, croppedBytes[c], dest, w * bpp);
            }
        }
        return croppedBytes;
    }

    public static int getPixelType(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (raster == null) {
            return -1;
        }
        DataBuffer buffer = raster.getDataBuffer();
        if (buffer == null) {
            return -1;
        }
        if (buffer instanceof SignedByteBuffer) {
            return 0;
        }
        if (buffer instanceof SignedShortBuffer) {
            return 2;
        }
        if (buffer instanceof UnsignedIntBuffer) {
            return 5;
        }
        int type = buffer.getDataType();
        int imageType = image.getType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                if (imageType == 1 || imageType == 4 || imageType == 2) {
                    return 1;
                }
                if (buffer instanceof UnsignedIntBuffer) {
                    return 5;
                }
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                if (imageType == 9 || imageType == 8) {
                    return 1;
                }
                return 3;
            }
        }
        return -1;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated) {
        byte[][] p = AWTImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        for (int i = 0; i < p.length; ++i) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
        }
        return rtn;
    }

    public static BufferedImage makeUnsigned(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        boolean fp = FormatTools.isFloatingPoint(pixelType);
        if (!signed || fp) {
            return img;
        }
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        byte[][] pix = AWTImageTools.getPixelBytes(img, false);
        return AWTImageTools.makeImage(pix, img.getWidth(), img.getHeight(), bpp, fp, false, false);
    }

    public static BufferedImage getSubimage(BufferedImage image, boolean littleEndian, long[] planeMin, long[] planeMax) {
        return AWTImageTools.getSubimage(image, littleEndian, (int)planeMin[0], (int)planeMin[1], (int)planeMax[0], (int)planeMax[1]);
    }

    public static BufferedImage getSubimage(BufferedImage image, boolean littleEndian, int x, int y, int w, int h) {
        int pixelType = AWTImageTools.getPixelType(image);
        byte[][] pix = AWTImageTools.getPixelBytes(image, littleEndian, x, y, w, h);
        return AWTImageTools.makeImage(pix, w, h, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), littleEndian, FormatTools.isSigned(pixelType));
    }

    public static BufferedImage[] splitChannels(BufferedImage image) {
        BufferedImage[] results;
        block7: {
            Object o;
            int c;
            int h;
            int w;
            block10: {
                block9: {
                    boolean signed;
                    block8: {
                        block6: {
                            w = image.getWidth();
                            h = image.getHeight();
                            c = image.getRaster().getNumBands();
                            if (c == 1) {
                                return new BufferedImage[]{image};
                            }
                            results = new BufferedImage[c];
                            o = AWTImageTools.getPixels(image);
                            int pixelType = AWTImageTools.getPixelType(image);
                            signed = FormatTools.isSigned(pixelType);
                            if (!(o instanceof byte[][])) break block6;
                            byte[][] pix = (byte[][])o;
                            for (int i = 0; i < c; ++i) {
                                results[i] = AWTImageTools.makeImage(pix[i], w, h, signed);
                            }
                            break block7;
                        }
                        if (!(o instanceof short[][])) break block8;
                        short[][] pix = (short[][])o;
                        for (int i = 0; i < c; ++i) {
                            results[i] = AWTImageTools.makeImage(pix[i], w, h, signed);
                        }
                        break block7;
                    }
                    if (!(o instanceof int[][])) break block9;
                    int[][] pix = (int[][])o;
                    for (int i = 0; i < c; ++i) {
                        results[i] = AWTImageTools.makeImage(pix[i], w, h, signed);
                    }
                    break block7;
                }
                if (!(o instanceof float[][])) break block10;
                float[][] pix = (float[][])o;
                for (int i = 0; i < c; ++i) {
                    results[i] = AWTImageTools.makeImage(pix[i], w, h);
                }
                break block7;
            }
            if (!(o instanceof double[][])) break block7;
            double[][] pix = (double[][])o;
            for (int i = 0; i < c; ++i) {
                results[i] = AWTImageTools.makeImage(pix[i], w, h);
            }
        }
        return results;
    }

    public static BufferedImage mergeChannels(BufferedImage[] images) {
        if (images == null || images.length == 0) {
            return null;
        }
        Object[] pixelArrays = new Object[images.length];
        int c = 0;
        int type = 0;
        for (int i = 0; i < images.length; ++i) {
            Object o = AWTImageTools.getPixels(images[i]);
            if (o instanceof byte[][]) {
                if (i == 0) {
                    type = 0;
                } else if (type != 0) {
                    return null;
                }
                c += ((byte[][])o).length;
            } else if (o instanceof short[][]) {
                if (i == 0) {
                    type = 1;
                } else if (type != 1) {
                    return null;
                }
                c += ((short[][])o).length;
            } else if (o instanceof int[][]) {
                if (i == 0) {
                    type = 3;
                } else if (type != 3) {
                    return null;
                }
                c += ((int[][])o).length;
            } else if (o instanceof float[][]) {
                if (i == 0) {
                    type = 4;
                } else if (type != 4) {
                    return null;
                }
                c += ((float[][])o).length;
            } else if (o instanceof double[][]) {
                if (i == 0) {
                    type = 5;
                } else if (type != 5) {
                    return null;
                }
                c += ((double[][])o).length;
            }
            if (c > 4) {
                return null;
            }
            pixelArrays[i] = o;
        }
        if (c < 1 || c > 4) {
            return null;
        }
        int w = images[0].getWidth();
        int h = images[0].getHeight();
        int pixelType = AWTImageTools.getPixelType(images[0]);
        boolean signed = FormatTools.isSigned(pixelType);
        if (type == 0) {
            byte[][] pix = new byte[c][];
            int ndx = 0;
            for (Object array : pixelArrays) {
                byte[][] bytes;
                for (byte[] byteValue : bytes = (byte[][])array) {
                    pix[ndx++] = byteValue;
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new byte[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h, signed);
        }
        if (type == 1 || type == 2) {
            short[][] pix = new short[c][];
            int ndx = 0;
            for (Object array : pixelArrays) {
                short[][] shorts;
                for (short[] shortsValue : shorts = (short[][])array) {
                    pix[ndx++] = shortsValue;
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new short[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h, signed);
        }
        if (type == 3) {
            int[][] pix = new int[c][];
            int ndx = 0;
            for (Object array : pixelArrays) {
                int[][] ints;
                for (int[] intValue : ints = (int[][])array) {
                    pix[ndx++] = intValue;
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new int[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h, signed);
        }
        if (type == 4) {
            float[][] pix = new float[c][];
            int ndx = 0;
            for (Object array : pixelArrays) {
                float[][] floats;
                for (float[] floatValue : floats = (float[][])array) {
                    pix[ndx++] = floatValue;
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new float[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        if (type == 5) {
            double[][] pix = new double[c][];
            int ndx = 0;
            for (Object array : pixelArrays) {
                double[][] doubles;
                for (double[] doublesValue : doubles = (double[][])array) {
                    pix[ndx++] = doublesValue;
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new double[w * h];
            }
            return AWTImageTools.makeImage(pix, w, h);
        }
        return null;
    }

    public static BufferedImage padImage(BufferedImage img, int width, int height) {
        boolean needsPadding;
        if (img == null) {
            byte[][] data = new byte[1][width * height];
            return AWTImageTools.makeImage(data, width, height, false);
        }
        boolean bl = needsPadding = img.getWidth() != width || img.getHeight() != height;
        if (needsPadding) {
            Object pixels = AWTImageTools.getPixels(img);
            int pixelType = AWTImageTools.getPixelType(img);
            boolean signed = FormatTools.isSigned(pixelType);
            if (pixels instanceof byte[][]) {
                byte[][] b = (byte[][])pixels;
                byte[][] newBytes = new byte[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newBytes[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newBytes, width, height, signed);
            }
            if (pixels instanceof short[][]) {
                short[][] b = (short[][])pixels;
                short[][] newShorts = new short[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newShorts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newShorts, width, height, signed);
            }
            if (pixels instanceof int[][]) {
                int[][] b = (int[][])pixels;
                int[][] newInts = new int[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newInts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newInts, width, height, signed);
            }
            if (pixels instanceof float[][]) {
                float[][] b = (float[][])pixels;
                float[][] newFloats = new float[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newFloats[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newFloats, width, height);
            }
            if (pixels instanceof double[][]) {
                double[][] b = (double[][])pixels;
                double[][] newDoubles = new double[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newDoubles[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newDoubles, width, height);
            }
            return null;
        }
        return img;
    }

    public static BufferedImage autoscale(BufferedImage img) {
        byte[][] pixels = AWTImageTools.getPixelBytes(img, true);
        double min = Double.MAX_VALUE;
        double max = 0.0;
        int bits = pixels[0].length / (img.getWidth() * img.getHeight()) * 8;
        for (int i = 0; i < pixels.length; ++i) {
            Double[] mm = ImageTools.scanData(pixels[0], bits, true);
            double tmin = mm[0];
            double tmax = mm[1];
            if (tmin < min) {
                min = tmin;
            }
            if (!(tmax > max)) continue;
            max = tmax;
        }
        return AWTImageTools.autoscale(img, (int)min, (int)max);
    }

    public static BufferedImage autoscale(BufferedImage img, int min, int max) {
        Object pixels = AWTImageTools.getPixels(img);
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        if (pixels instanceof byte[][]) {
            return img;
        }
        if (pixels instanceof short[][]) {
            short[][] shorts = (short[][])pixels;
            byte[][] out = new byte[shorts.length][shorts[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (shorts[i][j] < 0) {
                        short[] sArray = shorts[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + Short.MAX_VALUE);
                    }
                    int diff = max - min;
                    float dist = (float)(shorts[i][j] - min) / (float)diff;
                    out[i][j] = shorts[i][j] >= max ? -1 : (shorts[i][j] <= min ? 0 : (int)((int)(dist * 256.0f)));
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof int[][]) {
            int[][] ints = (int[][])pixels;
            byte[][] out = new byte[ints.length][ints[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (ints[i][j] >= max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (ints[i][j] <= min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (ints[i][j] - min) / diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof float[][]) {
            float[][] floats = (float[][])pixels;
            byte[][] out = new byte[floats.length][floats[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (floats[i][j] >= (float)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (floats[i][j] <= (float)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (floats[i][j] - (float)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof double[][]) {
            double[][] doubles = (double[][])pixels;
            byte[][] out = new byte[doubles.length][doubles[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (doubles[i][j] >= (double)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (doubles[i][j] <= (double)min) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min;
                    float dist = (float)(doubles[i][j] - (double)min) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        return img;
    }

    public static BufferedImage copyScaled(BufferedImage source, BufferedImage target, Object hint) {
        if (hint == null) {
            hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source, xform);
        g2.dispose();
        return target;
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int trans = image.getColorModel().getTransparency();
        return AWTImageTools.copyScaled(image, gc.createCompatibleImage(width, height, trans), hint);
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, ColorModel cm) {
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        return AWTImageTools.copyScaled(image, new BufferedImage(cm, raster, isRasterPremultiplied, null), hint);
    }

    public static Image scaleAWT(BufferedImage source, int width, int height, int hint) {
        return source.getScaledInstance(width, height, hint);
    }

    public static BufferedImage scale(BufferedImage source, int width, int height, boolean pad) {
        int w = source.getWidth();
        int h = source.getHeight();
        if (w == width && h == height) {
            return source;
        }
        int finalWidth = width;
        int finalHeight = height;
        if (pad) {
            double r = (double)w / (double)h;
            double ratio = (double)width / (double)height;
            if (r > ratio) {
                height = h * width / w;
            } else {
                width = w * height / h;
            }
        }
        int pixelType = AWTImageTools.getPixelType(source);
        BufferedImage result = null;
        ColorModel sourceModel = source.getColorModel();
        if (sourceModel instanceof Index16ColorModel || sourceModel instanceof IndexColorModel || sourceModel instanceof SignedColorModel) {
            DataBuffer buffer = source.getData().getDataBuffer();
            WritableRaster raster = Raster.createWritableRaster(source.getSampleModel(), buffer, null);
            ColorModel model = AWTImageTools.makeColorModel(1, buffer.getDataType());
            if (sourceModel instanceof SignedColorModel) {
                model = sourceModel;
            }
            source = new BufferedImage(model, raster, false, null);
            Image scaled = AWTImageTools.scaleAWT(source, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
            raster = Raster.createWritableRaster(result.getSampleModel(), result.getData().getDataBuffer(), null);
            result = new BufferedImage(sourceModel, raster, false, null);
        } else {
            if (FormatTools.isSigned(pixelType)) {
                source = AWTImageTools.makeUnsigned(source);
                sourceModel = null;
            }
            Image scaled = AWTImageTools.scaleAWT(source, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
        }
        return AWTImageTools.padImage(result, finalWidth, finalHeight);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        AWTImageTools.loadImage(image);
        BufferedImage img = new BufferedImage(image.getWidth(OBS), image.getHeight(OBS), 1);
        Graphics g = img.getGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return img;
    }

    public static BufferedImage makeBuffered(Image image, ColorModel cm) {
        BufferedImage bi;
        if (cm == null) {
            return AWTImageTools.makeBuffered(image);
        }
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        AWTImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h = image.getHeight(OBS);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, OBS);
        g.dispose();
        return result;
    }

    public static boolean loadImage(Image image) {
        if (image instanceof BufferedImage) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(OBS);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            return false;
        }
        return 8 == tracker.statusID(0, false);
    }

    public static Dimension getSize(Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return new Dimension(bi.getWidth(), bi.getHeight());
        }
        AWTImageTools.loadImage(image);
        return new Dimension(image.getWidth(OBS), image.getHeight(OBS));
    }

    public static BufferedImage makeCompatible(BufferedImage image, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int trans = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(w, h, trans);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static ColorSpace makeColorSpace(int c) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return TwoChannelColorSpace.getInstance(type);
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        ColorSpace cs = AWTImageTools.makeColorSpace(c);
        return cs == null ? null : new ComponentColorModel(cs, c == 4, false, 3, dataType);
    }

    public static BufferedImage indexedToRGB(BufferedImage img, boolean le) {
        byte[][] indices = AWTImageTools.getPixelBytes(img, le);
        if (indices.length > 1) {
            return img;
        }
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        if (pixelType == 1) {
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            byte[][] b = new byte[3][indices[0].length];
            for (int i = 0; i < indices[0].length; ++i) {
                b[0][i] = (byte)(model.getRed(indices[0][i] & 0xFF) & 0xFF);
                b[1][i] = (byte)(model.getGreen(indices[0][i] & 0xFF) & 0xFF);
                b[2][i] = (byte)(model.getBlue(indices[0][i] & 0xFF) & 0xFF);
            }
            return AWTImageTools.makeImage(b, img.getWidth(), img.getHeight(), signed);
        }
        if (pixelType == 3) {
            Index16ColorModel model = (Index16ColorModel)img.getColorModel();
            short[][] s = new short[3][indices[0].length / 2];
            for (int i = 0; i < s[0].length; ++i) {
                int ndx = Bytes.toInt((byte[])indices[0], (int)(i * 2), (int)2, (boolean)le) & 0xFFFF;
                s[0][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[1][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s[2][i] = (short)(model.getRed(ndx) & 0xFFFF);
            }
            return AWTImageTools.makeImage(s, img.getWidth(), img.getHeight(), signed);
        }
        return null;
    }

    public static byte[][] get8BitLookupTable(ColorModel model) {
        if (!(model instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel m = (IndexColorModel)model;
        byte[][] lut = new byte[3][m.getMapSize()];
        m.getReds(lut[0]);
        m.getGreens(lut[1]);
        m.getBlues(lut[2]);
        return lut;
    }

    public static short[][] getLookupTable(ColorModel model) {
        if (!(model instanceof Index16ColorModel)) {
            return null;
        }
        Index16ColorModel m = (Index16ColorModel)model;
        short[][] lut = new short[][]{m.getReds(), m.getGreens(), m.getBlues()};
        return lut;
    }
}

