/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractPlane;
import io.scif.ImageMetadata;
import io.scif.gui.AWTImageTools;
import java.awt.image.BufferedImage;
import org.scijava.Context;
import org.scijava.util.Bytes;

public class BufferedImagePlane
extends AbstractPlane<BufferedImage, BufferedImagePlane> {
    byte[] cachedBytes = null;

    public BufferedImagePlane(Context context) {
        super(context);
    }

    public BufferedImagePlane(Context context, ImageMetadata meta, long[] planeOffsets, long[] planeBounds) {
        super(context, meta, planeOffsets, planeBounds);
    }

    @Override
    public byte[] getBytes() {
        if (this.cachedBytes == null) {
            switch (((BufferedImage)this.getData()).getColorModel().getComponentSize(0)) {
                case 8: {
                    this.cachedBytes = AWTImageTools.getBytes((BufferedImage)this.getData(), false);
                    break;
                }
                case 16: {
                    short[][] ts = AWTImageTools.getShorts((BufferedImage)this.getData());
                    this.cachedBytes = new byte[ts.length * ts[0].length * 2];
                    for (int c = 0; c < ts.length; ++c) {
                        int offset = c * ts[c].length * 2;
                        for (int i = 0; i < ts[c].length; ++i) {
                            Bytes.unpack((long)ts[c][i], (byte[])this.cachedBytes, (int)offset, (int)2, (boolean)this.getImageMetadata().isLittleEndian());
                            offset += 2;
                        }
                    }
                    break;
                }
            }
        }
        return this.cachedBytes;
    }

    @Override
    protected BufferedImage blankPlane(long[] planeOffsets, long[] planeBounds) {
        int type = this.getImageMetadata().getPixelType();
        long[] axes = new long[planeOffsets.length];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = planeBounds[i] - planeOffsets[i];
        }
        return AWTImageTools.blankImage(this.getImageMetadata(), axes, type);
    }

    @Override
    public void setData(BufferedImage data) {
        super.setData(data);
        this.cachedBytes = null;
    }
}

