/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.DataPlane;
import io.scif.ImageMetadata;
import io.scif.Plane;
import net.imglib2.display.ColorTable;
import org.scijava.AbstractContextual;
import org.scijava.Context;

public abstract class AbstractPlane<T, P extends DataPlane<T>>
extends AbstractContextual
implements DataPlane<T> {
    private T data = null;
    private ColorTable lut = null;
    private ImageMetadata meta = null;
    private long[] offsets;
    private long[] lengths;

    public AbstractPlane(Context context) {
        this.setContext(context);
    }

    public AbstractPlane(Context context, ImageMetadata meta, long[] planeOffsets, long[] planeBounds) {
        this.setContext(context);
        this.populate(meta, planeOffsets, planeBounds);
    }

    @Override
    public void setData(T data) {
        this.data = data;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public void setColorTable(ColorTable lut) {
        this.lut = lut;
    }

    @Override
    public ColorTable getColorTable() {
        return this.lut;
    }

    @Override
    public ImageMetadata getImageMetadata() {
        return this.meta;
    }

    @Override
    public long[] getOffsets() {
        return this.offsets;
    }

    @Override
    public long[] getLengths() {
        return this.lengths;
    }

    public P populate(Plane p) {
        return (P)this.populate(p.getImageMetadata(), p.getOffsets(), p.getLengths());
    }

    public P populate(DataPlane<T> plane) {
        return this.populate(plane.getImageMetadata(), plane.getData(), plane.getOffsets(), plane.getLengths());
    }

    public P populate(ImageMetadata meta, long[] planeOffsets, long[] planeBounds) {
        return this.populate(meta, null, planeOffsets, planeBounds);
    }

    public P populate(T data, long[] planeOffsets, long[] planeBounds) {
        return this.populate(null, data, planeOffsets, planeBounds);
    }

    public P populate(ImageMetadata meta, T data, long[] planeOffsets, long[] planeBounds) {
        this.setImageMetadata(meta);
        if (data == null) {
            data = this.blankPlane(planeOffsets, planeBounds);
        }
        this.setData(data);
        this.setOffsets(planeOffsets);
        this.setLengths(planeBounds);
        AbstractPlane pl = this;
        return (P)pl;
    }

    @Override
    public void setImageMetadata(ImageMetadata meta) {
        this.meta = meta;
    }

    @Override
    public void setOffsets(long[] planeOffsets) {
        this.offsets = planeOffsets;
    }

    @Override
    public void setLengths(long[] planeBounds) {
        this.lengths = planeBounds;
    }

    protected abstract T blankPlane(long[] var1, long[] var2);
}

