/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerStream
extends PrintStream {
    private Level _level = null;
    private Logger _logger = null;
    private ByteArrayOutputStream _baos = (ByteArrayOutputStream)this.out;

    public LoggerStream(Logger logger, Level level) {
        super(new ByteArrayOutputStream(), true);
        this._logger = logger;
        this._level = level;
    }

    @Override
    public synchronized void flush() {
        super.flush();
        if (this._baos.size() == 0) {
            return;
        }
        String out1 = this._baos.toString();
        this._logger.log(this._level, out1);
        this._baos.reset();
    }

    @Override
    public synchronized void println() {
        this.flush();
    }

    @Override
    public synchronized void println(Object x) {
        this.print(x);
        this.flush();
    }

    @Override
    public synchronized void println(String x) {
        this.print(x);
        this.flush();
    }

    @Override
    public synchronized void close() {
        this.flush();
        super.close();
    }

    @Override
    public synchronized boolean checkError() {
        this.flush();
        return super.checkError();
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger("edu.mines.jtk.util");
        LoggerStream psInfo = new LoggerStream(logger, Level.INFO);
        psInfo.print(3.0);
        ((PrintStream)psInfo).println("*3.=9.");
        psInfo.print(3.0);
        ((PrintStream)psInfo).flush();
        ((PrintStream)psInfo).println("*3.=9.");
        ((PrintStream)psInfo).println();
        psInfo.print("x");
        ((PrintStream)psInfo).close();
    }
}

